/**
 * Copyright (c) 2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.monitoring.sensor;

import java.util.Map;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.binding.soap.listener.outgoing.ServiceClientKey;
import org.ow2.petals.probes.api.sensor.KeyedGaugeSensor;

/**
 * Sensor attached to the clients in use of the pools of service clients used to
 * call external web services.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class WsClientPoolsClientsInUseGaugeSensor implements
        KeyedGaugeSensor<ServiceClientKey, Long, Long> {

    /**
     * The pools of service clients used to call external web services.
     */
    protected Map<ServiceClientKey, GenericObjectPool> wsClientPools;

    @Override
    public Long getInstantValue(final ServiceClientKey key) {

        final ObjectPool currentPool = this.wsClientPools.get(key);
        if (currentPool != null) {
            return Long.valueOf(currentPool.getNumActive());
        } else {
            // The pool does not exist. This should not occur !
            return 0l;
        }
    }

    @Override
    public final Long toExternalValue(final Long valueToConvert) {
        return valueToConvert;
    }

    @Override
    public final void reset() {
        // NOP
    }

    public final void setWsClientPools(final Map<ServiceClientKey, GenericObjectPool> wsClientPools) {
        this.wsClientPools = wsClientPools;
    }
}
