/**
 * Copyright (c) 2009-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.util;

import static org.junit.Assert.assertEquals;

import org.apache.axiom.soap.SOAPEnvelope;
import org.junit.Test;

/**
 * @author Christophe Hamerling - EBM WebSourcing
 */
public class AxiomUtilsTest {

    @Test
    public void testGetHrefElementsOne() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-001-onehref.xml", 11);
        assertEquals(AxiomUtils.getHrefElements(soapEnvelope).size(), 1);
    }

    @Test
    public void testGetHrefElementsTwo() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-003-twohref.xml", 11);
        assertEquals(AxiomUtils.getHrefElements(soapEnvelope).size(), 2);
    }

    @Test
    public void testGetHrefElementsNo() throws Exception {
        SOAPEnvelope soapEnvelope = SOAPTestUtil.loadSOAPEnvelope("/multiref-002-nohref.xml", 11);
        assertEquals(AxiomUtils.getHrefElements(soapEnvelope).size(), 0);
    }

}
