/**
 * Copyright (c) 2009-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.util;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;

/**
 * @author Christophe Hamerling - EBM WebSourcing
 */
public class SOAPTestUtil {

	public static final SOAPEnvelope loadSOAPEnvelope(String resourceName,
			int soapversion) throws Exception {
		Source source = loadSource(resourceName);
		final XMLStreamReader parser = StaxUtils.createXMLStreamReader(source);
		SOAPFactory factory = null;
		if (soapversion == 11) {
			factory = new SOAP11Factory();
		} else if (soapversion == 12) {
			factory = new SOAP12Factory();
		} else {
			throw new Exception("Unknow version " + soapversion);
		}

		StAXSOAPModelBuilder staxbuilder = OMXMLBuilderFactory
				.createStAXSOAPModelBuilder(factory, parser);
		return staxbuilder.getSOAPEnvelope();
	}

	private static final Source loadSource(String resourceName) {
		return new StreamSource(SOAPTestUtil.class.getClass()
				.getResourceAsStream(resourceName));
	}

}
