/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.component.framework.api;

import java.util.Map;
import java.util.logging.Logger;

import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;

/**
 * 
 * Created on 15 mai 2008
 * 
 * @author Christophe HAMERLING - EBM WebSourcing
 * @since 1.0
 * 
 */
public interface PetalsComponent extends javax.jbi.component.Component, ComponentLifeCycle {

    /**
     * Returns the component delivery channel, used to send messages to petals
     * container
     * 
     * @return the delivery channel. Not null.
     */
    public DeliveryChannel getChannel();

    /**
     * The component context
     * 
     * @return the component context. Not null.
     */
    public ComponentContext getContext();

    /**
     * Returns the component logger
     * 
     * @return component logger. Not null.
     */
    public Logger getLogger();

    /**
     * Get all the interceptors
     * 
     * @return
     */
    public Map<String, Interceptor> getInterceptors();

    /**
     * Get the interceptor that have the given name.
     * 
     * @param name
     * @return null if the interceptor is not found of is there are no
     *         interceptor in the component
     */
    public Interceptor getInterceptor(final String name);
}
