/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2005-2006 ObjectWeb, http://www.objectweb.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id: $
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.component.framework.api.exception;

import java.net.URI;

import javax.xml.namespace.QName;

/**
 * <p>
 * This exception represents the fault named "Server" pre-defined in the
 * specifications of SOAP 1.1.
 * <ul>
 * <li>the fault code is set with:
 * <code>{http://schemas.xmlsoap.org/soap/envelope/}Server</code>,</li>
 * <li>the fault string is set with the provided value,</li>
 * <li>the fault actor is set with the provided value,</li>
 * <li>the detail is set with the exception stack trace.</li>
 * </ul>
 * </p>
 * 
 * @author Christophe DENEUX - Capgemini Sud
 * @since 1.0
 */
public class SOAP11FaultServerException extends FaultException {
    private static final long serialVersionUID = 7472580574365097485L;

    public SOAP11FaultServerException(final String faultString, final URI faultActor) {
        super(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), faultString,
                faultActor);
    }

    public SOAP11FaultServerException(final String faultString, final URI faultActor,
            final Throwable cause) {
        super(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), faultString,
                faultActor, cause);
    }
}
