/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api.notification;

import javax.jbi.messaging.MessagingException;

import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;

/**
 * @author Frederic Gardes
 * 
 */
public interface NotificationConsumer extends NotificationActor {

    /**
     * notify from the publisher to the broker
     * 
     * @param notify
     *            The notify
     * @throws WSNotificationException
     * @throws MessagingException
     * @throws PEtALSCDKException
     */
    public void notify(Notify notify) throws WSNotificationException, MessagingException,
            PEtALSCDKException;

    /**
     * Get the NotificationConsumerReference SOAParameter into the wsdl
     * 
     * @return The NotificationConsumerReference SOAParameter
     * @throws WSDLException
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     */
    public SOAParameterType getNotificationConsumerSOAParameter() throws WSDLException,
            WSNotificationException, WSAddressingException, WSNotificationExtensionException;
}
