/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api.notification;

import javax.jbi.messaging.MessagingException;

import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;

import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;

/**
 * The controller of notification
 * 
 * @author Frederic Gardes
 * 
 */
public interface NotificationController {

    /**
     * Register the publisher on the broker, by a basic way
     * 
     * @param topicExpressionNamespace
     *            The namespace of the topic expression. For example:
     *            "http://petals.ow2.org/topic"
     * @param topicExpression
     *            The topic expression. For example:
     *            "component/cdk//*[@wstop:topic='true']"
     * @return The uuid of the registration, to provide on the destroy
     *         registration
     * @throws WSNotificationException
     * @throws MessagingException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws PEtALSCDKException
     */
    public String registerPublisher(String topicExpressionNamespace, String topicExpression)
    throws WSNotificationException, WSAddressingException,
    WSNotificationExtensionException, MessagingException, PEtALSCDKException;

    /**
     * Register the publisher on the broker, by an expert way<br />
     * Manage the wrapping from the address to the JBI endpoints<br />
     * Store the consumer received to notify, and the publisher registration
     * management received to destroy the registration later
     * 
     * @param registerPublisher
     *            The register publisher, externally created by the wsstar
     *            factory
     * @return The response of the registration, with the uuid to provide on the
     *         destroy registration
     * @throws WSNotificationException
     * @throws MessagingException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws PEtALSCDKException
     */
    public RegisterPublisherResponse registerPublisher(RegisterPublisher registerPublisher)
    throws WSNotificationException, WSAddressingException,
    WSNotificationExtensionException, MessagingException, PEtALSCDKException;

    /**
     * Destroy the registration of the publisher on the broker, by a basic way
     * 
     * @param registrationUuid
     *            The uuid provided by the registration
     * @throws WSNotificationException
     * @throws WSAddressingException
     * @throws WSNotificationExtensionException
     * @throws PEtALSCDKException
     * @throws MessagingException
     */
    public void destroyRegistration(String registrationUuid) throws WSNotificationException,
    WSAddressingException, WSNotificationExtensionException, MessagingException,
    PEtALSCDKException;

    /**
     * Destroy the registration of the publisher on the broker, by an expert way
     * Manage the wrapping from the address to the JBI endpoints<br />
     * Use the publisher registration management, received on the register
     * publisher, to destroy the registration
     * 
     * @param destroyRegistration
     *            The destroy registration, externally created by the wsstar
     *            factory
     * @return The response of the destroy registration
     * @throws WSNotificationException
     * @throws WSAddressingException
     * @throws WSNotificationExtensionException
     * @throws PEtALSCDKException
     * @throws MessagingException
     */
    public DestroyRegistrationResponse destroyRegistration(DestroyRegistration destroyRegistration)
    throws WSNotificationException, WSAddressingException,
    WSNotificationExtensionException, MessagingException, PEtALSCDKException;

    /**
     * Get the wsdl of the consumer
     * 
     * @return the wsdl of the consumer service
     */
    public Wsdl getConsumerWsdl();

    /**
     * Get the wsdl of the producer
     * 
     * @return the wsdl of the producer service
     */
    public Wsdl getProducerWsdl();

}
