/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api.notification;

import java.util.Map;

import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;

import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.notify.NotifyController;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;

/**
 * The Producer of notification into the bus
 * 
 * @author Frederic Gardes
 * 
 */
public interface NotificationProducer extends NotificationActor {
    /**
     * Manage the subscription from a consumer or a broker
     * 
     * @param Subscribe
     *            The subscribe to process
     * @throws PEtALSCDKException
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSDLException
     * @throws WSAddressingException
     * @throws MessagingException
     * @throws WSNotificationFault
     * @throws ParserConfigurationException
     * @throws TransformerException
     * @throws TransformerFactoryConfigurationError
     * @throws XPathExpressionException
     */
    public SubscribeResponse subscribe(Subscribe subscribe) throws PEtALSCDKException,
    WSNotificationException, WSNotificationExtensionException, WSAddressingException,
    WSDLException, MessagingException, WSNotificationFault, XPathExpressionException,
    TransformerFactoryConfigurationError, TransformerException,
    ParserConfigurationException;

    /**
     * Provide the current message
     * 
     * @param getCurrentMessage
     *            The getCurrentMessage to process
     */
    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage getCurrentMessage);

    /**
     * Manage the renew on a subscription from a consumer or a broker
     * 
     * @param renew
     *            The renew to process
     */
    public RenewResponse renew(Renew renew);

    /**
     * Manage the unsubscription from a consumer or a broker
     * 
     * @param unsubscribe
     *            The unsubscribe to process
     * @throws PEtALSCDKException
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     * @throws MessagingException
     * @throws WSNotificationFault
     */
    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribe) throws PEtALSCDKException,
    WSNotificationException, WSNotificationExtensionException, WSAddressingException, MessagingException, WSNotificationFault;

    /**
     * Get the NotificationProducer SOAParameter into the wsdl
     * 
     * @return The NotificationProducer SOAParameter
     * @throws WSDLException
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     */
    public SOAParameterType getNotificationProducerSOAParameter() throws WSDLException,
    WSNotificationException, WSNotificationExtensionException, WSAddressingException;

    /**
     * Get the SubscriptionManagerReference SOAParameter into the wsdl
     * 
     * @return The SubscriptionManager SOAParameter
     * @throws WSDLException
     * @throws WSNotificationException
     * @throws WSNotificationExtensionException
     * @throws WSAddressingException
     */
    public SOAParameterType getSubscriptionManagerSOAParameter() throws WSDLException,
    WSNotificationException, WSNotificationExtensionException, WSAddressingException;

    /**
     * Get the subscriptionMap
     * 
     * @return the subscriptionMap
     */
    public Map<EndpointReferenceType, Subscribe> getSubscriptionMap();

    /**
     * Get the notifyController
     * 
     * @return the notifyController
     */
    public NotifyController getNotifyController();
}
