/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api.notification.notify;

import org.w3c.dom.Document;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;

/**
 * The notification interface
 * 
 * @author Frederic Gardes
 * 
 */
public interface Notify {

    /**
     * Send the notification TODO: use document fragment
     * 
     * @param document
     *            the message document to set as payload
     * @param topic
     *            the topic to set
     * @param subscriptionReference
     *            The subscription reference
     * @param PolicyList
     *            The list of policies
     */
    void process(Document document, String topic, EndpointReferenceType subscriptionReference);
}
