/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ---------------------------------------------------------------------------
 * ---------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api.notification.notify;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;

import org.ow2.petals.component.framework.api.message.Exchange;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;

/**
 * This controller centralize the Component Notify's. It creates them one time
 * at the subscription, and delete them at the unsubscription. It delivers them
 * at the Producer witch process them.
 * 
 * @author Frederic Gardes
 */
public interface NotifyController {

    /**
     * Add a subscription and create its Component Notify list
     * 
     * @param subscriptionReference
     *            The subscription reference
     * @param subscribe
     *            The subscription to store
     * @throws WSNotificationException
     * @throws ParserConfigurationException
     * @throws TransformerException
     * @throws TransformerFactoryConfigurationError
     * @throws XPathExpressionException
     * @throws WSNotificationExtensionException
     */
    public void add(final EndpointReferenceType subscriptionReference, final Subscribe subscribe)
    throws WSNotificationException, WSNotificationExtensionException,
    XPathExpressionException, TransformerFactoryConfigurationError, TransformerException,
    ParserConfigurationException;

    /**
     * Remove a subscription
     * 
     * @param subscriptionReference
     *            The subscription reference to remove
     */
    public void remove(final EndpointReferenceType subscriptionReference);


    /**
     * Process a kind of Notify
     * 
     * @param clazz
     *            The Class of Notify to process
     * @param exchange
     *            The exchange used by create the Notify
     */
    public void process(final Class<?> clazz, final Exchange exchange);
}
