
package org.ow2.petals.component.framework.api.util;

import org.ow2.petals.commons.util.IDGenerator;

/***
 * Provide utility to manipulate endpoint.
 * 
 * @author ”Mathieu CARROLLE - mathieu.carrolle@petalslink.com”
 * 
 */
public class EndpointUtil {

    /**
     * The endpoint prefix.
     */
    private final static String EDPT_PREFIX = "edpt-";

    /***
     * Generate an unique endpoint value
     * 
     * @return
     *      The endpoint name
     */
    public final static String generateEndpointName(){
        final String id = IDGenerator.getInstance().getNewID(false);
        return new StringBuilder(EDPT_PREFIX).append(id).toString();
    }
}
