/**
 * PETALS - PETALS Services Platform. Copyright (c) 2005 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * ------------------------------------------------------------------------- $Id
 * $ -------------------------------------------------------------------------
 */
package org.ow2.petals.component.framework.api.util;

import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;

import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;

/**
 * Contains utilities for the Exchange management.
 * 
 * @author Frederic Gardes
 * @author nsalatge - eBMWebsourcing
 */
public interface ExchangeUtil {
    /**
     * create a new exchange copy of a source exchange
     * 
     * @param mef
     *            The factory to be able to create the new exchange
     * @param source
     *            the source exchange
     * @return the new exchange
     * @throws MessagingException
     * @throws PEtALSCDKException
     * 
     */
    Exchange copyExchange(final MessageExchangeFactory mef, final Exchange source)
    throws MessagingException, PEtALSCDKException;

    /**
     * Copies a message's content, properties and attachments in another.
     * 
     * @param source
     *            the source normalized message
     * @param target
     *            the target normalized message
     * @throws MessagingException
     * @throws PEtALSCDKException
     */
    void copyNormalizedMessage(final NormalizedMessage source, final NormalizedMessage target)
    throws MessagingException, PEtALSCDKException;

    /**
     * Copies the exchange's properties in another exchange.
     * 
     * @param source
     *            the source exchange
     * @param target
     *            the target exchange
     * @throws MessagingException
     * @throws PEtALSCDKException
     */
    void copyExchangeProperties(final Exchange source, final Exchange target)
    throws MessagingException, PEtALSCDKException;

    /**
     * Verify if the fault set is a real business fault, or an exception
     * inserted into a fault (to respect the InOut MEP for example)
     * 
     * @param fault
     *            : the fault to check
     * @return true if the fault isn't functional, is a PEtALS exception. false
     *         else
     * @throws PEtALSCDKException
     */
    boolean isPetalsException(Fault fault) throws PEtALSCDKException;

    /**
     * Check if the JBI exchange is a base notification exchange
     * 
     * @param exchange
     *            the JBI exchange
     * @return true if the exchange is a notification exchange, false else
     */
    boolean isBaseNotification(final Exchange exchange);
}
