/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api.configuration;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.util.Arrays;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.component.framework.api.configuration.SuConfigurationParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SuConfigurationParametersTest {
    private static final String PLACEHOLDER_1 = "placeholder-1";
    private static final String PLACEHOLDER_1_VALUE_1 = "placeholder-1-value-1";
    private static final String PLACEHOLDER_1_VALUE_2 = "placeholder-1-value-2";
    private static final String PLACEHOLDER_2_VALUE_1 = "placeholder-2-value-1";
    private static final String PLACEHOLDER_2 = "placeholder-2";
    private static final String ELEMENT_NAME_1 = "element-1";
    private static final String ELEMENT_VALUE_1 = "element-value-1";
    private static final String ELEMENT_NAME_2 = "element-2";
    private static final String ELEMENT_NAME_3 = "element-3";

    @Test
    public void withPlaceHolders() {
        Properties placeHolders = new Properties();
        placeHolders.setProperty(PLACEHOLDER_1, PLACEHOLDER_1_VALUE_1);
        Document doc = DocumentBuilders.newDocument();
        Element elt_1 = doc.createElementNS("", ELEMENT_NAME_1);
        elt_1.setTextContent(ELEMENT_VALUE_1);
        Element elt_2 = doc.createElementNS("", ELEMENT_NAME_2);
        elt_2.setTextContent("${placeholder-1}");
        SuConfigurationParameters suCfgParams = new SuConfigurationParameters(Arrays.asList(elt_1, elt_2), placeHolders);
        Assert.assertEquals((Object)ELEMENT_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_1));
        Assert.assertEquals((Object)PLACEHOLDER_1_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_2));
        suCfgParams.put(ELEMENT_NAME_3, "${placeholder-2}");
        placeHolders.setProperty(PLACEHOLDER_1, PLACEHOLDER_1_VALUE_2);
        suCfgParams.reloadPlaceholderValues();
        Assert.assertEquals((Object)ELEMENT_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_1));
        Assert.assertEquals((Object)PLACEHOLDER_1_VALUE_2, (Object)suCfgParams.get(ELEMENT_NAME_2));
        Assert.assertEquals((Object)"${placeholder-2}", (Object)suCfgParams.get(ELEMENT_NAME_3));
        placeHolders.setProperty(PLACEHOLDER_2, PLACEHOLDER_2_VALUE_1);
        suCfgParams.reloadPlaceholderValues();
        Assert.assertEquals((Object)PLACEHOLDER_2_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_3));
    }

    @Test
    public void withPlaceHoldersGivenAsNull() {
        Document doc = DocumentBuilders.newDocument();
        Element elt_1 = doc.createElementNS("", ELEMENT_NAME_1);
        elt_1.setTextContent(ELEMENT_VALUE_1);
        Element elt_2 = doc.createElementNS("", ELEMENT_NAME_2);
        elt_2.setTextContent("${placeholder-1}");
        SuConfigurationParameters suCfgParams = new SuConfigurationParameters(Arrays.asList(elt_1, elt_2), null);
        Assert.assertEquals((Object)ELEMENT_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_1));
        Assert.assertEquals((Object)"${placeholder-1}", (Object)suCfgParams.get(ELEMENT_NAME_2));
        suCfgParams.put(ELEMENT_NAME_3, "${placeholder-2}");
        suCfgParams.reloadPlaceholderValues();
        Assert.assertEquals((Object)ELEMENT_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_1));
        Assert.assertEquals((Object)"${placeholder-1}", (Object)suCfgParams.get(ELEMENT_NAME_2));
        Assert.assertEquals((Object)"${placeholder-2}", (Object)suCfgParams.get(ELEMENT_NAME_3));
    }

    @Test
    public void withPlaceHoldersGivenAsEmptyPropertyset() {
        Properties placeHolders = new Properties();
        Document doc = DocumentBuilders.newDocument();
        Element elt_1 = doc.createElementNS("", ELEMENT_NAME_1);
        elt_1.setTextContent(ELEMENT_VALUE_1);
        Element elt_2 = doc.createElementNS("", ELEMENT_NAME_2);
        elt_2.setTextContent("${placeholder-1}");
        SuConfigurationParameters suCfgParams = new SuConfigurationParameters(Arrays.asList(elt_1, elt_2), placeHolders);
        Assert.assertEquals((Object)ELEMENT_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_1));
        Assert.assertEquals((Object)"${placeholder-1}", (Object)suCfgParams.get(ELEMENT_NAME_2));
        placeHolders.setProperty(PLACEHOLDER_1, PLACEHOLDER_1_VALUE_2);
        suCfgParams.reloadPlaceholderValues();
        Assert.assertEquals((Object)ELEMENT_VALUE_1, (Object)suCfgParams.get(ELEMENT_NAME_1));
        Assert.assertEquals((Object)PLACEHOLDER_1_VALUE_2, (Object)suCfgParams.get(ELEMENT_NAME_2));
    }
}

