/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api.util;

import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.ow2.petals.component.framework.api.util.PropertiesUtil;

public class PropertiesUtilTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void loadProperties() throws IOException, PropertiesException {
        Properties expectedProperties = new Properties();
        String expectedKey = "expectedKey";
        String expectedValue = "expectedValue";
        expectedProperties.setProperty("expectedKey", "expectedValue");
        File propertiesFile = this.tempFolder.newFile();
        expectedProperties.store(new FileOutputStream(propertiesFile), "");
        Properties propertiesNull = PropertiesUtil.loadProperties(null);
        Assert.assertEquals((long)0L, (long)propertiesNull.size());
        Properties propertiesFromAbsPath = PropertiesUtil.loadProperties((String)propertiesFile.getAbsolutePath());
        Assert.assertEquals((long)1L, (long)propertiesFromAbsPath.size());
        Assert.assertEquals((Object)"expectedValue", (Object)propertiesFromAbsPath.getProperty("expectedKey"));
        Properties propertiesFromURL = PropertiesUtil.loadProperties((String)propertiesFile.toURI().toURL().toExternalForm());
        Assert.assertEquals((long)1L, (long)propertiesFromURL.size());
        Assert.assertEquals((Object)"expectedValue", (Object)propertiesFromURL.getProperty("expectedKey"));
    }
}

