/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api;

import java.util.List;

/**
 * The interface of a monitoring object
 * 
 * @author Christophe DENEUX - Linagora
 */
public interface MonitoringObject {

    /**
     * @return the monitoring object name. Not <code>null</code>.
     */
    public String getName();

    /**
     * @return the monitoring object description. Not <code>null</code>.
     */
    public String getDescription();

    /**
     * @return the list of sub-functions provided by the monitoring object. Not
     *         <code>null</code>.
     */
    public List<MonitoringSubFunction> getSubFunctions();

}
