/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api;

import java.util.Map;

import org.ow2.petals.cli.api.shell.Shell;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.DuplicatedMonitoringObjectException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.DuplicatedMonitoringSubFunctionException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.InvalidMonitoringObjectNameException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.InvalidMonitoringSubFunctionNameException;

/**
 * The interface of a monitoring object registror, registering monitoring
 * object.
 * 
 * @author Christophe DENEUX - Linagora
 */
public interface MonitoringObjectRegistror {

    /**
     * Register a monitoring object.
     * 
     * @param monitoringObject
     *            The monitoring object to register. Not <code>null</code> and
     *            its sub-function list must be not <code>null</code>.
     * @throws IllegalArgumentException
     *             The monitoring object is <code>null</code> or the monitoring
     *             object has a <code>null</code> list of sub-function.
     * @throws DuplicatedMonitoringObjectException
     *             The monitoring object is already defined
     * @throws DuplicatedMonitoringSubFunctionException
     *             A monitoring sub-function is registered twice in a monitoring
     *             object.
     * @throws InvalidMonitoringObjectNameException
     *             Monitoring object name is invalid
     * @throws InvalidMonitoringSubFunctionNameException
     *             A monitoring sub-function name is invalid
     */
    public void registersMonitoringObjects(final MonitoringObject monitoringObject)
            throws DuplicatedMonitoringObjectException, DuplicatedMonitoringSubFunctionException,
            InvalidMonitoringObjectNameException, InvalidMonitoringSubFunctionNameException,
            IllegalArgumentException;

    /**
     * Get the available monitoring objects
     * 
     * @return a set of monitoring objects mapped with their name
     */
    public Map<String, MonitoringObject> getMonitoringObjects();

    /**
     * @return The shell in which the monitoring object and sub-function will
     *         run
     */
    public Shell getShell();

}
