/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api;

import org.apache.commons.cli.Options;
import org.ow2.petals.cli.api.shell.Shell;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.MonitoringSubFunctionBadArgumentNumberException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.MonitoringSubFunctionException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.MonitoringSubFunctionInvalidArgumentException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.MonitoringSubFunctionInvalidException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.MonitoringSubFunctionMissingArgumentException;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.MonitoringSubFunctionMissingOptionsException;


/**
 * The interface of a sub-function of a monitoring object
 * 
 * @author Christophe DENEUX - Linagora
 */
public interface MonitoringSubFunction {

    /**
     * @return The sub-function name. Not <code>null</code>.
     */
    public String getName();

    /**
     * @return The sub-function description. Not <code>null</code>.
     */
    public String getDescription();

    /**
     * @return The sub-function options
     */
    public Options getOptions();

    /**
     * After each arguments parsing, it is needed to reset {@link Options} of
     * the sub-function.
     */
    public void resetOptions();

    /**
     * Define the Petals CLI shell in which the monitoring sub-function is
     * running
     * 
     * @param shell
     *            The Petals CLI shell in which the monitoring sub-function is
     *            running
     */
    public void setShell(final Shell shell);

    /**
     * @return The {@link Shell} associated to this monitoring sub-function.
     */
    public Shell getShell();

    /**
     * Execute the monitoring sub-function
     * 
     * @param args
     *            Arguments of the monitoring sub-function to execute
     * @throws MonitoringSubFunctionBadArgumentNumberException
     *             Bad argument number for the monitoring sub-function
     * @throws MonitoringSubFunctionInvalidArgumentException
     *             An argument of the monitoring sub-function has an invalid
     *             value
     * @throws MonitoringSubFunctionMissingArgumentException
     *             An argument is missing for one option of the monitoring
     *             sub-function
     * @throws MonitoringSubFunctionMissingOptionsException
     *             An required option of the monitoring sub-function is missing
     * @throws MonitoringSubFunctionInvalidException
     *             A parsing error occurs on arguments of the monitoring
     *             sub-function
     * @throws MonitoringSubFunctionException
     *             An error occurs during the monitoring sub-function parsing or
     *             execution.
     */
    public void execute(final String[] args)
            throws MonitoringSubFunctionBadArgumentNumberException,
            MonitoringSubFunctionInvalidArgumentException,
            MonitoringSubFunctionMissingArgumentException,
            MonitoringSubFunctionMissingOptionsException, MonitoringSubFunctionInvalidException,
            MonitoringSubFunctionException;

}
