/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api.exception;

import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringObject;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringSubFunction;

/**
 * A monitoring sub-function has been registered twice.
 * 
 * @author Christophe DENEUX - Linagora
 * 
 */
public class DuplicatedMonitoringSubFunctionException extends MonitoringSubFunctionException {

    private static final long serialVersionUID = 5886071143179650590L;

    /**
     * The monitoring object having a sub-function registered twice.
     */
    private final MonitoringObject monitoringObject;

    public DuplicatedMonitoringSubFunctionException(
            final MonitoringSubFunction monitoringSubFunction,
            final MonitoringObject monitoringObject) {
        super(monitoringSubFunction, "The monitoring sub-function '"
                + monitoringSubFunction.getName()
                + "' is registered twice into the monitoing object '" + monitoringObject.getName()
                + "'.");
        this.monitoringObject = monitoringObject;
	}

    /**
     * @return The monitoring object having a sub-function registered twice.
     */
    public MonitoringObject getMonitoringObject() {
        return this.monitoringObject;
    }
}
