/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api.exception;

import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringObject;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringSubFunction;

/**
 * The name of the monitoring sub function is invalid.
 * 
 * @author Christophe DENEUX - Linagora
 * 
 */
public class InvalidMonitoringSubFunctionNameException extends MonitoringObjectException {

    private static final long serialVersionUID = -1775884607437496109L;

    /**
     * The monitoring sub function having an invalid name
     */
    private final MonitoringSubFunction monitoringSubFunction;

    public InvalidMonitoringSubFunctionNameException(final MonitoringObject monitoringObject,
            final MonitoringSubFunction monitoringSubFunction) {
        super(monitoringObject, "The monitoring object '"
                + monitoringObject.getName() + "' has an invalid sub-function name '"
                + monitoringSubFunction.getName() + "'.");
        this.monitoringSubFunction = monitoringSubFunction;
	}

    /**
     * @return The monitoring sub function having an invalid name
     */
    public MonitoringSubFunction getMonitoringSubFunction() {
        return this.monitoringSubFunction;
    }
}
