/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api.exception;

import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringSubFunction;

/**
 * Exception thrown when an error occurs on the number of arguments of the
 * monitoring sub-function.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class MonitoringSubFunctionBadArgumentNumberException extends MonitoringSubFunctionException {

    private static final long serialVersionUID = -1477609157307715208L;

    public static final String BAD_NUMBER_OF_ARGUMENTS_OR_INCOMPATIBLE_ARGUMENTS = "Bad number of arguments or incompatible arguments";

    public MonitoringSubFunctionBadArgumentNumberException(
            final MonitoringSubFunction monitoringSubFunction) {
        super(monitoringSubFunction, BAD_NUMBER_OF_ARGUMENTS_OR_INCOMPATIBLE_ARGUMENTS);
    }

}
