/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api.exception;

import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringSubFunction;

/**
 * A monitoring sub-function exception.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class MonitoringSubFunctionException extends Exception {

    private static final long serialVersionUID = 2602443637801909488L;

    /**
     * The monitoring sub-function implied in the error
     */
    private final MonitoringSubFunction monitoringSubFunction;

    public MonitoringSubFunctionException(final MonitoringSubFunction monitoringSubFunction,
            final String message, final Throwable cause) {
        super(message, cause);
        this.monitoringSubFunction = monitoringSubFunction;
    }

    public MonitoringSubFunctionException(final MonitoringSubFunction monitoringSubFunction,
            final String message) {
        super(message);
        this.monitoringSubFunction = monitoringSubFunction;
    }

    public MonitoringSubFunctionException(final MonitoringSubFunction monitoringSubFunction,
            final Throwable cause) {
        super(cause);
        this.monitoringSubFunction = monitoringSubFunction;
    }

    /**
     * @return The monitoring sub-function implied in the error
     */
    public MonitoringSubFunction getMonitoringSubFunction() {
        return this.monitoringSubFunction;
    }

}
