/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api.exception;

import org.apache.commons.cli.Option;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringSubFunction;

/**
 * Exception thrown when an argument of a sub-function has an invalid value.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class MonitoringSubFunctionInvalidArgumentException extends
        MonitoringSubFunctionInvalidException {

    private static final long serialVersionUID = 7548525790477871813L;

    public static final String INVALID_ARGUMENT_VALUE = "Argument value of option '-%s' has an invalid value '%s'";

    public static final String INVALID_LONG_ARGUMENT_VALUE = "Argument value of option '--%s' has an invalid value '%s'";

    /**
     * The option for which the argument has an invalid value.
     */
    private final Option option;

    /**
     * The invalid value.
     */
    private final String value;

    public MonitoringSubFunctionInvalidArgumentException(
            final MonitoringSubFunction monitoringSubFunction, final Option option,
            final String value) {
        super(monitoringSubFunction, option.getOpt() == null ? String.format(
                INVALID_LONG_ARGUMENT_VALUE, option.getLongOpt(), value) : String.format(
                INVALID_ARGUMENT_VALUE, option.getOpt(), value));
        this.option = option;
        this.value = value;
    }

    /**
     * @return The option for which the argument has an invalid value.
     */
    public Option getOption() {
        return this.option;
    }

    /**
     * @return The invalid value.
     */
    public String getValue() {
        return this.value;
    }

}
