/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api.exception;

import org.apache.commons.cli.Option;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringSubFunction;

/**
 * Exception thrown when an error occurs on argument parsing of the monitoring
 * sub-function.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class MonitoringSubFunctionMissingArgumentException extends
        MonitoringSubFunctionInvalidException {

    private static final long serialVersionUID = -7866917545455146363L;

    public static final String MISSING_ARGUMENT = "Missing argument";

    /**
     * The option for which an argument is missing.
     */
    private final Option option;

    public MonitoringSubFunctionMissingArgumentException(
            final MonitoringSubFunction monitoringObject,
            final Option option) {
        super(monitoringObject, MISSING_ARGUMENT + ": "
                + (option.getOpt() == null ? option.getLongOpt() : option.getOpt()));
        this.option = option;
    }

    /**
     * @return The option for which an argument is missing.
     */
    public Option getOption() {
        return this.option;
    }

}
