/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api.exception;

import java.util.Iterator;
import java.util.List;

import org.ow2.petals.cli.extension.command.monitoring.mo.api.MonitoringSubFunction;

/**
 * Exception thrown when a required option of the monitoring sub-function is
 * missing.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class MonitoringSubFunctionMissingOptionsException extends
        MonitoringSubFunctionInvalidException {

    private static final long serialVersionUID = 1071510665638948239L;

    public static final String MISSING_OPTIONS = "Missing option(s)";

    /**
     * The missing options
     */
    private final List missingOptions;

    public MonitoringSubFunctionMissingOptionsException(
            final MonitoringSubFunction monitoringSubFunction,
            final List missingOptions) {
        super(monitoringSubFunction, MonitoringSubFunctionMissingOptionsException
                .createMessage(missingOptions));
        this.missingOptions = missingOptions;
    }

    private final static String createMessage(final List missingOptions) {
        final StringBuffer message = new StringBuffer(MISSING_OPTIONS).append(':');
        final Iterator itMissingOptions = missingOptions.iterator();
        while (itMissingOptions.hasNext()) {
            message.append(itMissingOptions.next());
            if (itMissingOptions.hasNext()) {
                message.append(", ");
            }
        }
        return message.toString();
    }

    /**
     * @return The missing options
     */
    public List getMissingOptions() {
        return this.missingOptions;
    }

}
