/**
 * Copyright (c) 2012-2013 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.cli.extension.command.monitoring.mo.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.cli.Options;
import org.ow2.petals.cli.api.shell.Shell;
import org.ow2.petals.cli.extension.command.monitoring.mo.api.exception.MonitoringSubFunctionException;

public class DummyMonitoringObject implements MonitoringObject {

    private final List<MonitoringSubFunction> subFunctions = new ArrayList<MonitoringSubFunction>();

    public DummyMonitoringObject() {
        this.subFunctions.add(new MonitoringSubFunction() {

            @Override
            public String getName() {
                return "dummy-fct";
            }

            @Override
            public String getDescription() {
                return "dummy-fct description";
            }

            @Override
            public void execute(String[] args) throws MonitoringSubFunctionException {
            }

            @Override
            public Options getOptions() {
                return null;
            }

            @Override
            public void setShell(Shell shell) {
            }

            @Override
            public void resetOptions() {
            }

            @Override
            public Shell getShell() {
                return null;
            }
        });
    }

    @Override
    public String getName() {
        return "dummy";
    }

    @Override
    public String getDescription() {
        return "dummy mo description";
    }

    @Override
    public List<MonitoringSubFunction> getSubFunctions() {
        return Collections.unmodifiableList(this.subFunctions);
    }

}
