/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2007 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Transcoder.java 
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.se.transcoder;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.ow2.petals.se.transcoder.util.TranscoderQuery;

/**
 * @author Anne-Marie BARTHE (ambarthe) - eBM WebSourcing
 * 
 */
public interface Transcoder {

    /**
     * Translate a value of a row in a table, giving the following parameters
     * 
     * @param connection
     * @param transcoderQuery,
     *            the object containing the query parameters
     * @throws TranscoderException
     * @throws SQLException
     */
    public ResultSet translate(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException;

    /**
     * Update a row in a table, giving the following parameters
     * 
     * @param connection
     * @param transcoderQuery,
     *            the object containing the query parameters
     * @throws TranscoderException
     */
    public ResultSet update(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException;

    /**
     * Create a 2-field row in a table, giving the following parameters Id field
     * should be one of the two following columns. If the id is automatically
     * generated, please use only one field
     * 
     * @param connection
     * @param transcoderQuery,
     *            the object containing the query parameters
     * @throws TranscoderException
     * @throws SQLException
     */
    public ResultSet create(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException;

    /**
     * Delete a row in a table, giving the following parameters
     * 
     * @param connection
     * @param transcoderQuery,
     *            the object containing the query parameters
     * @throws TranscoderException
     * @throws SQLException
     */
    public ResultSet delete(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException;

}
