/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2007 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TranscoderEngine.java 
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.se.transcoder;

import java.util.logging.Level;

import javax.jbi.JBIException;

import org.ow2.petals.component.framework.se.AbstractServiceEngine;

/**
 * 
 * @author Anne-Marie BARTHE (ambarthe) - eBMWebSourcing
 *
 */
public class TranscoderEngine extends AbstractServiceEngine {

    /**
     * The default constructor
     * 
     */
    public TranscoderEngine() {
        super();
    }

    /*
     * (non-Javadoc)
     * @see org.ow2.petals.component.framework.AbstractComponent#doInit()
     */
    @Override
    protected final void doInit() throws JBIException {
        this.getLogger().log(Level.INFO, "Transcoder Initialization...");
        // set service unit listener
        final TranscoderSUListener suListener = new TranscoderSUListener();
        this.setServiceUnitListener(suListener);
    }
}
