/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2007 EBM WebSourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TranscoderException.java 
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.se.transcoder;

import org.ow2.petals.component.framework.exception.PEtALSCDKException;

/**
 * The Transcoder exception class
 * 
 * @author Anne-Marie BARTHE (ambarthe) - eBMWebSourcing
 * 
 */
public class TranscoderException extends PEtALSCDKException {

    private static final long serialVersionUID = -7380617238760172407L;

    private String messageKey;

    /**
     * Default constructor
     * 
     * @param message
     *            the raw message explaining the cause of the error
     */
    public TranscoderException(final String message) {
        super(message);
    }

    /**
     * @param message
     *            the raw message explaining the cause of the error
     * @param messageKey
     *            key matching a message to display for internationalization
     */
    public TranscoderException(String message, String messageKey) {
        super(message);
        this.messageKey = messageKey;
    }

    /**
     * @param message
     *            the raw message explaining the cause of the error
     * @param cause
     *            the exception
     */
    public TranscoderException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * @param message
     *            the raw message explaining the cause of the error
     * @param cause
     *            the exception
     * @param messageKey
     *            key matching a message to display for internationalization
     */
    public TranscoderException(String message, Throwable cause, String messageKey) {
        super(message, cause);
        this.messageKey = messageKey;
    }

    /**
     * @param cause
     *            the exception
     */
    public TranscoderException(Throwable cause) {
        super(cause);
    }

}
