/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2007 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TranscoderImpl.java 
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.se.transcoder;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.ow2.petals.component.framework.util.StringHelper;
import org.ow2.petals.se.transcoder.util.TranscoderQuery;

/**
 * 
 * @author Anne-Marie BARTHE (ambarthe) - eBMWebSourcing
 * 
 */
public class TranscoderImpl implements Transcoder {

    /**
     * Creates a new instance of {@link TranscoderImpl}
     */
    public TranscoderImpl() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.se.transcoder.Transcoder#create(java.sql.Connection,
     *      org.ow2.petals.se.transcoder.util.TranscoderQuery)
     */
    public ResultSet create(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException {
        ResultSet result = null;

        if (!StringHelper.isNullOrEmpty(trancoderQuery.getTabName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOValue())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColTName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColTValue())) {
            try {
                // Create the statement
                Statement statement = connection.createStatement();

                // Create the query
                StringBuffer queryBuf = new StringBuffer();
                queryBuf.append("INSERT INTO ");
                queryBuf.append(trancoderQuery.getTabName());
                queryBuf.append(" (");
                queryBuf.append(trancoderQuery.getColOName());
                queryBuf.append(" ,");
                queryBuf.append(trancoderQuery.getColTName());
                queryBuf.append(") VALUES ('");
                queryBuf.append(trancoderQuery.getColOValue());
                queryBuf.append("','");
                queryBuf.append(trancoderQuery.getColTValue());
                queryBuf.append(");");

                // Execute the query
                result = statement.executeQuery(queryBuf.toString());

            } catch (SQLException e) {
                throw new TranscoderException(
                        "Error inserting data using tableName, columnOneName, columnOneValue, columnTwoName and columnTwoValue :"
                                + trancoderQuery.getTabName()
                                + " & "
                                + trancoderQuery.getColOName()
                                + " & "
                                + trancoderQuery.getColOValue()
                                + " & "
                                + trancoderQuery.getColTName()
                                + " & "
                                + trancoderQuery.getColTValue(), e);
            }

            /* In the case where the id is automatically generated for instance */
        } else if ((!StringHelper.isNullOrEmpty(trancoderQuery.getTabName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOValue())
                && StringHelper.isNullOrEmpty(trancoderQuery.getColTName()) && StringHelper
                .isNullOrEmpty(trancoderQuery.getColTValue()))) {

            try {
                // Create the statement
                Statement statement = connection.createStatement();

                // Create the query
                StringBuffer queryBuf = new StringBuffer();
                queryBuf.append("INSERT INTO ");
                queryBuf.append(trancoderQuery.getTabName());
                queryBuf.append(" (");
                queryBuf.append(trancoderQuery.getColOName());
                queryBuf.append(") VALUES ('");
                queryBuf.append(trancoderQuery.getColOValue());
                queryBuf.append("');");

                // Execute the query
                result = statement.executeQuery(queryBuf.toString());

            } catch (SQLException e) {
                throw new TranscoderException(
                        "Error inserting data using tableName, columnOneName, columnOneValue :"
                                + trancoderQuery.getTabName() + " & "
                                + trancoderQuery.getColOName() + " & "
                                + trancoderQuery.getColOValue(), e);
            }
        } else {
            throw new TranscoderException(
                    "tableName and/or columnOneName and/or columnOneValue, and/or columnTwoName or columnTwoValue is/are empty");
        }

        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.se.transcoder.Transcoder#delete(java.sql.Connection,
     *      org.ow2.petals.se.transcoder.util.TranscoderQuery)
     */
    public ResultSet delete(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException {
        ResultSet result = null;

        if (!StringHelper.isNullOrEmpty(trancoderQuery.getTabName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOValue())
                && StringHelper.isNullOrEmpty(trancoderQuery.getColTName())
                && StringHelper.isNullOrEmpty(trancoderQuery.getColTValue())) {

            try {
                // Create the statement
                Statement statement = connection.createStatement();

                // Create the query
                StringBuffer queryBuf = new StringBuffer();
                queryBuf.append("DELETE FROM ");
                queryBuf.append(trancoderQuery.getTabName());
                queryBuf.append(" WHERE UPPER(");
                queryBuf.append(trancoderQuery.getColOName());
                queryBuf.append(") = UPPER('");
                queryBuf.append(trancoderQuery.getColOValue());
                queryBuf.append("');");

                // Execute the query
                result = statement.executeQuery(queryBuf.toString());

            } catch (SQLException e) {
                throw new TranscoderException(
                        "Error deleting data using tableName, columnOneName and columnOneValue :"
                                + trancoderQuery.getTabName() + " & "
                                + trancoderQuery.getColOName() + " & "
                                + trancoderQuery.getColOValue(), e);
            }
        } else {
            throw new TranscoderException(
                    "tableName and/or columnOneName and/or columnOneValue is/are empty");
        }

        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.se.transcoder.Transcoder#translate(java.sql.Connection,
     *      org.ow2.petals.se.transcoder.util.TranscoderQuery)
     */
    public ResultSet translate(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException {
        ResultSet result = null;

        if (!StringHelper.isNullOrEmpty(trancoderQuery.getTabName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOValue())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColTName())
                && StringHelper.isNullOrEmpty(trancoderQuery.getColTValue())) {

            try {
                // Create the statement
                Statement statement = connection.createStatement();

                // Create the query
                StringBuffer queryBuf = new StringBuffer();
                queryBuf.append("SELECT ");
                queryBuf.append(trancoderQuery.getColTName());
                queryBuf.append(" FROM ");
                queryBuf.append(trancoderQuery.getTabName());
                queryBuf.append(" WHERE UPPER(");
                queryBuf.append(trancoderQuery.getColOName());
                queryBuf.append(") = UPPER('");
                queryBuf.append(trancoderQuery.getColOValue());
                queryBuf.append("');");

                // Execute the query
                result = statement.executeQuery(queryBuf.toString());

            } catch (SQLException e) {
                throw new TranscoderException(
                        "Error translating data using tableName, columnOneName, columnOneValue and columnTwoName :"
                                + trancoderQuery.getTabName() + " & "
                                + trancoderQuery.getColOName() + " & "
                                + trancoderQuery.getColOValue() + " & "
                                + trancoderQuery.getColTName(), e);
            }
        } else {
            throw new TranscoderException(
                    "tableName and/or columnOneName and/or columnOneValue and/or columnTwoName  is/are empty");
        }

        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.se.transcoder.Transcoder#update(java.sql.Connection,
     *      org.ow2.petals.se.transcoder.util.TranscoderQuery)
     */
    public ResultSet update(Connection connection, TranscoderQuery trancoderQuery)
            throws TranscoderException, SQLException {
        ResultSet result = null;

        if (!StringHelper.isNullOrEmpty(trancoderQuery.getTabName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColOValue())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColTName())
                && !StringHelper.isNullOrEmpty(trancoderQuery.getColTValue())) {

            try {
                // Create the statement
                Statement statement = connection.createStatement();

                // Create the query
                StringBuffer queryBuf = new StringBuffer();
                queryBuf.append("UPDATE ");
                queryBuf.append(trancoderQuery.getTabName());
                queryBuf.append(" SET ");
                queryBuf.append(trancoderQuery.getColTName());
                queryBuf.append(" = '");
                queryBuf.append(trancoderQuery.getColTValue());
                queryBuf.append("' WHERE UPPER(");
                queryBuf.append(trancoderQuery.getColOName());
                queryBuf.append(") = UPPER('");
                queryBuf.append(trancoderQuery.getColOValue());
                queryBuf.append("');");

                // Execute the query
                result = statement.executeQuery(queryBuf.toString());

            } catch (SQLException e) {
                throw new TranscoderException(
                        "Error updating data using tableName, columnOneName, columnOneValue, columnTwoName and columnTwoValue :"
                                + trancoderQuery.getTabName()
                                + " & "
                                + trancoderQuery.getColOName()
                                + " & "
                                + trancoderQuery.getColOValue()
                                + " & "
                                + trancoderQuery.getColTName()
                                + " & "
                                + trancoderQuery.getColTValue(), e);
            }
        } else {
            throw new TranscoderException(
                    "tableName and/or columnOneName and/or columnOneValue and/or columnTwoName and/or columnTwoValue is/are empty");
        }

        return result;
    }
}
