/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2007 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TranscoderQuery.java 
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.se.transcoder.util;

/**
 * @author Anne-Marie BARTHE (ambarthe) - eBM WebSourcing
 * 
 */
public class TranscoderQuery {

    /** The name of the table */
    public String tabName;

    /** The name of the column 'One' */
    public String colOName;

    /** The name of the column 'Two' */
    public String colTName;

    /** The value of the column 'One' */
    public String colOValue;

    /** The value of the column 'Two' */
    public String colTValue;

    /**
     * 
     * @param tabName
     * @param colOName
     * @param colOValue
     * @param colTName
     * @param colTValue
     */
    public TranscoderQuery(String tabName, String colOName, String colOValue, String colTName,
            String colTValue) {
        super();
        this.tabName = tabName;
        this.colOName = colOName;
        this.colTName = colTName;
        this.colOValue = colOValue;
        this.colTValue = colTValue;
    }

    public String getTabName() {
        return tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getColOName() {
        return colOName;
    }

    public void setColOName(String colOName) {
        this.colOName = colOName;
    }

    public String getColTName() {
        return colTName;
    }

    public void setColTName(String colTName) {
        this.colTName = colTName;
    }

    public String getColOValue() {
        return colOValue;
    }

    public void setColOValue(String colOValue) {
        this.colOValue = colOValue;
    }

    public String getColTValue() {
        return colTValue;
    }

    public void setColTValue(String colTValue) {
        this.colTValue = colTValue;
    }

}
