/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2007 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * XMLTagContent.java 
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.se.transcoder.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.ParserConfigurationException;

import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/**
 * @author Anne-Marie BARTHE (ambarthe) - eBM WebSourcing
 * 
 */

public class XMLTagContent {

    /* InMessage parameters */
    public static final String TABLE_NAME = "table-name";

    public static final String COLUMN_ONE_NAME = "column-one-name";

    public static final String COLUMN_TWO_NAME = "column-two-name";

    public static final String COLUMN_ONE_VALUE = "column-one-value";

    public static final String COLUMN_TWO_VALUE = "column-two-value";

    /**
     * 
     * @param document
     * @return
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws MessagingException
     */
    public static TranscoderQuery getValues(Document document) throws SAXException, IOException,
            ParserConfigurationException, MessagingException {

        // Create a new TranscoderQuery object, where the found values will be
        // pushed
        TranscoderQuery trancoderQuery = new TranscoderQuery("", "", "", "", "");

        // Getting the root element
        Element root = document.getDocumentElement();

        // Get a node list of the root elements
        List<Node> children = XMLUtil.getNodeChildren(root);

        // Getting each child of the root element,
        // using an iterator on the previous defined node list
        Iterator<Node> i = children.iterator();
        try {
            while (i.hasNext()) {
                // A current element (named child) is created at each loop
                Element child = (Element) i.next();

                // Getting the text between the XML tags and push it into the
                // relevant variable
                if (TABLE_NAME.equalsIgnoreCase(child.getNodeName())) {
                    trancoderQuery.setTabName(child.getTextContent());
                } else if (COLUMN_ONE_NAME.equalsIgnoreCase(child.getNodeName())) {
                    trancoderQuery.setColOName(child.getTextContent());
                } else if (COLUMN_ONE_VALUE.equalsIgnoreCase(child.getNodeName())) {
                    trancoderQuery.setColOValue(child.getTextContent());
                } else if (COLUMN_TWO_NAME.equalsIgnoreCase(child.getNodeName())) {
                    trancoderQuery.setColTName(child.getTextContent());
                } else if (COLUMN_TWO_VALUE.equalsIgnoreCase(child.getNodeName())) {
                    trancoderQuery.setColTValue(child.getTextContent());
                }
            }
        } catch (Exception e) {
            throw new MessagingException("Document is empty : ", e);
        }
        return trancoderQuery;
    }

}
