/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.util.auditreport.api.IDisplayableType;
import org.ow2.util.auditreport.api.IEncodableType;
import org.ow2.util.auditreport.impl.LifeCycleAuditReport;

public final class EncodingType {
    private static final Pattern STACKTRACE_PATTERN = Pattern.compile("([^(]+)\\(([^:]+):([0-9]+)");
    public static final IDisplayableType<StackTraceElement[]> STACKTRACE = new IDisplayableType<StackTraceElement[]>(){

        public String toString(StackTraceElement[] stackTrace) {
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement elmt : stackTrace) {
                builder.append(elmt.getClassName());
                builder.append('#');
                builder.append(elmt.getMethodName());
                builder.append('#');
                builder.append(elmt.getFileName());
                builder.append('#');
                builder.append(elmt.getLineNumber());
                builder.append('\n');
            }
            return builder.toString();
        }

        public StackTraceElement[] fromString(String stackTrace) {
            String[] traces = stackTrace.split("\n");
            StackTraceElement[] elmts = new StackTraceElement[traces.length];
            for (int i = 0; i < elmts.length; ++i) {
                String[] values = traces[i].split("#");
                elmts[i] = new StackTraceElement(values[0], values[1], values[2], Integer.parseInt(values[3]));
            }
            return elmts;
        }

        public Object encodedToDisplayable(String encodedStackTrace) {
            String[] traces = encodedStackTrace.split("\n");
            LinkedList<String> result = new LinkedList<String>();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < traces.length; ++i) {
                String[] values = traces[i].split("#");
                builder.append(values[0]);
                builder.append('.');
                builder.append(values[1]);
                builder.append('(');
                builder.append(values[2]);
                builder.append(':');
                builder.append(values[3]);
                builder.append(')');
                result.add(builder.toString());
                builder.setLength(0);
            }
            return result;
        }

        public String displayableToEncoded(Object strObject) {
            List stacktraces = (List)strObject;
            StringBuilder builder = new StringBuilder();
            for (String stacktrace : stacktraces) {
                Matcher matcher = STACKTRACE_PATTERN.matcher(stacktrace);
                if (!matcher.find()) continue;
                String function = matcher.group(0);
                int index = function.lastIndexOf(".");
                builder.append(function.substring(0, index));
                builder.append('#');
                builder.append(function.substring(index + 1));
                builder.append('#');
                builder.append(matcher.group(1));
                builder.append('#');
                builder.append(Integer.parseInt(matcher.group(2)));
                builder.append('\n');
            }
            return builder.toString();
        }
    };
    public static final IEncodableType<Object[]> OBJECTTABLE = new IEncodableType<Object[]>(){

        public String toString(Object[] object) {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            for (Object elmt : object) {
                if (elmt == null) continue;
                builder.append(elmt.toString());
                builder.append(" - ");
            }
            if (builder.length() >= 3) {
                builder.setLength(builder.length() - 3);
            }
            builder.append(']');
            return builder.toString();
        }

        public Object[] fromString(String object) {
            String tmp = object.replace("[", "");
            tmp = tmp.replace("]", "");
            return tmp.split(" - ");
        }
    };
    public static final IEncodableType<List> LIST = new IEncodableType<List>(){

        public String toString(List list) {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            if (list != null) {
                for (Object elmt : list) {
                    if (elmt == null) continue;
                    builder.append(elmt.toString());
                    builder.append(" - ");
                }
            }
            if (builder.length() >= 3) {
                builder.setLength(builder.length() - 3);
            }
            builder.append(']');
            return builder.toString();
        }

        public List fromString(String object) {
            String tmp = object.replace("[", "");
            tmp = tmp.replace("]", "");
            return Arrays.asList(tmp.split(" - "));
        }
    };
    public static final IEncodableType<Object> OBJECT = new IEncodableType<Object>(){

        public String toString(Object object) {
            return object.toString();
        }

        public Object fromString(String object) {
            return object;
        }
    };
    public static final IEncodableType<Object> LCENUM = new IEncodableType<Object>(){

        public String toString(Object object) {
            return object.toString();
        }

        public LifeCycleAuditReport.STEP fromString(String object) {
            if (object.equals("STARTING")) {
                return LifeCycleAuditReport.STEP.STARTING;
            }
            if (object.equals("STARTED")) {
                return LifeCycleAuditReport.STEP.STARTED;
            }
            if (object.equals("STOPPING")) {
                return LifeCycleAuditReport.STEP.STOPPING;
            }
            return LifeCycleAuditReport.STEP.STOPPED;
        }
    };

    private EncodingType() {
    }
}

