/**
 * OW2 Util
 * Copyright (C) 2006-2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Component.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.component.api;

/**
 * Defines the interface that a component needs to implement.
 * @author Florent Benoit
 */
public interface Component {

    /**
     * Init method.<br/>
     * This method is called before the start method.
     * @throws ComponentException if the initialization has failed.
     */
    void init() throws ComponentException;


    /**
     * Start method.<br/>
     * This method is called after the init method.
     * @throws ComponentException if the start has failed.
     */
    void start() throws ComponentException;


    /**
     * Stop method.<br/>
     * This method is called when component needs to be stopped.
     * @throws ComponentException if the stop is failing.
     */
    void stop() throws ComponentException;

}
