/**
 * OW2 Util
 * Copyright (C) 2007-2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IComponentRegistry.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.component.api;

import java.util.List;

/**
 * This interface is the registry of the Components.
 * @author Florent Benoit
 */
public interface IComponentRegistry {

    /**
     * Allow to get a reference on another component.
     * @param componentName the name of the component
     * @return the component.
     */
    Component getComponent(final String componentName);

    /**
     * @param component EZBComponent instance.
     * @return Returns the component name from the EZBComponent instance.
     */
    String getComponentName(final Component component);

    /**
     * Get the components that implements the given interface.
     * @param itf the given interface
     * @return an array of components implementing the given interface
     * @param <T> an interface extending EZBComponent.
     */
    <T extends Component> List<T> getComponents(final Class<T> itf);

    /**
     * Register a component.
     * @param componentName the name of the component to register
     * @param component the component to register.
     * @throws ComponentException if registering fails.
     */
    void register(final String componentName, final Component component) throws ComponentException;

    /**
     * Unregister a component.
     * @param componentName the component name to unregister.
     * @throws ComponentException if unregistering fails.
     */
    void unregister(final String componentName) throws ComponentException;

    /**
     * Unregister a component.
     * @param component the instance of the component to unregister.
     * @throws ComponentException if unregistering fails.
     */
    void unregister(final Component component) throws ComponentException;
}
