/**
 * EasyBeans
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Constants.java 4672 2009-02-20 15:24:30Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.builder.webserviceref;

/**
 * Hold all the Generic constants values that may be used when
 * dealing with web services References.
 * @author Guillaume Sauthier
 */
public enum Constants {

    /**
     * Key to retrieve the service classname.
     */
     SERVICE_CLASS,

    /**
     * Key to retrieve the service-ref annotation.
     */
    SERVICE_REF_ANNOTATION,

    /**
     * Key to retrieve the service interface classname.
     */
     SERVICE_INTERFACE,

    /**
     * Key to retrieve the service endpoint interface classname.
     */
    SERVICE_ENDPOINT_INTERFACE,

    /**
     * Key to retrieve the handler chain structure to be used with this service.
     */
    HANDLER_CHAIN_STRUCT,

    /**
     * Key to retrieve the handler chain file to be used with this service.
     */
    HANDLER_CHAIN_FILE,

    /**
     * Key to retrieve the declaring class supporting a @HandlerChain.
     */
    DECLARING_CLASS,

    /**
     * Key to retrieve the WSDL URL.
     */
    WSDL_LOCATION,

    /**
     * Key to retrieve the service qname.
     */
    SERVICE_QNAME,
}
