/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: PortProcessorImpl.java 5360 2010-02-24 14:29:45Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.builder.webserviceref.factory;

import java.util.Iterator;
import java.util.Properties;
import java.util.Map.Entry;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;

import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPortComponentRef;

/**
 * Allows to defines action for a given port before returning it to the user.
 * @author Florent Benoit
 */
public class PortProcessorImpl implements IPortProcessor {

    /**
     * IJaxwsWebServiceRef.
     */
    private IJaxwsWebServiceRef serviceRef = null;


    /**
     * Build a processor around the given service ref.
     * @param serviceRef the given service ref
     */
    public PortProcessorImpl(final IJaxwsWebServiceRef serviceRef) {
        this.serviceRef = serviceRef;
    }

    /**
     * Process the given port object.
     * @param port the port to process
     * @param serviceEndpointInterface the endPointInterface of the given port
     * @param <T> the type of the port.
     */
    public <T> void postProcess(final T port, final Class<T> serviceEndpointInterface) {
        // check if there is port Component ref ?
        IPortComponentRef portComponentRef = serviceRef.getPortComponentRef(serviceEndpointInterface.getName());

        // Found a matching port component ref
        if (portComponentRef != null) {

            // Enable MTOM ?
            if (portComponentRef.isEnableMTOM()) {
                ((SOAPBinding) ((BindingProvider) port).getBinding()).setMTOMEnabled(true);
            }

            // Set all given properties on the port
            Properties stubProperties = portComponentRef.getStubProperties();
            if (stubProperties != null) {
                Iterator<Entry<Object, Object>> itProperties = stubProperties.entrySet().iterator();
                while (itProperties.hasNext()) {
                    Entry<Object, Object> entry = itProperties.next();
                    ((BindingProvider) port).getRequestContext().put(entry.getKey().toString(), entry.getValue());
                }
            }

        }
    }


}
