/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployable;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployment.ear.IEARInfo;
import org.ow2.util.ee.deploy.api.deployment.ear.WebModule;
import org.ow2.util.ee.deploy.impl.deployable.AbsDeployable;
import org.ow2.util.ee.deploy.impl.deployable.LibDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.ConnectorModuleImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.EARInfoImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.EJBModuleImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.JavaModuleImpl;
import org.ow2.util.ee.deploy.impl.deployment.ear.WebModuleImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARDeployableImpl
extends AbsDeployable<EARDeployable>
implements EARDeployable {
    private static final String APPLICATION_XML_ENTRY = "META-INF/application.xml";
    private static final String DEFAULT_LIBRARY_FOLDER = "lib/";
    private Log logger = LogFactory.getLog(EARDeployableImpl.class);
    private EARInfoImpl earInfo = null;
    private List<IDeployable> allDeployables = null;
    private List<EJB21Deployable> ejb21Deployables = null;
    private List<EJB3Deployable> ejb3Deployables = null;
    private List<WARDeployable> warDeployables = null;
    private List<RARDeployable> rarDeployables = null;
    private List<CARDeployable> carDeployables = null;
    private List<LibDeployable> libDeployables = null;
    private Map<URL, IDeployable> mapUrl = new HashMap<URL, IDeployable>();

    public EARDeployableImpl(IArchive archive) {
        super(archive);
        this.allDeployables = new ArrayList<IDeployable>();
        this.ejb21Deployables = new ArrayList<EJB21Deployable>();
        this.ejb3Deployables = new ArrayList<EJB3Deployable>();
        this.warDeployables = new ArrayList<WARDeployable>();
        this.rarDeployables = new ArrayList<RARDeployable>();
        this.carDeployables = new ArrayList<CARDeployable>();
        this.libDeployables = new ArrayList<LibDeployable>();
        this.analyzeDD();
    }

    private void analyzeDD() {
        URL applicationXMLURL = null;
        try {
            applicationXMLURL = this.getArchive().getResource(APPLICATION_XML_ENTRY);
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get entry 'META-INF/application.xml' on the archive '" + this.getArchive().getName() + "'.", e);
        }
        this.earInfo = new EARInfoImpl();
        if (applicationXMLURL == null) {
            return;
        }
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)applicationXMLURL, (boolean)false, null);
        }
        catch (DocumentParserException e) {
            throw new IllegalStateException("Cannot parse the url", e);
        }
        Element applicationRootElement = document.getDocumentElement();
        NodeList moduleList = applicationRootElement.getElementsByTagName("module");
        for (int i = 0; i < moduleList.getLength(); ++i) {
            Element moduleElement = (Element)moduleList.item(i);
            NodeList connectorList = moduleElement.getElementsByTagName("connector");
            for (int j = 0; j < connectorList.getLength(); ++j) {
                String path = connectorList.item(j).getFirstChild().getNodeValue().trim();
                ConnectorModuleImpl connectorModule = new ConnectorModuleImpl();
                connectorModule.setPath(path);
                this.earInfo.addConnectorModule(connectorModule);
            }
            NodeList ejbList = moduleElement.getElementsByTagName("ejb");
            for (int j = 0; j < ejbList.getLength(); ++j) {
                String path = ejbList.item(j).getFirstChild().getNodeValue().trim();
                EJBModuleImpl ejbModule = new EJBModuleImpl();
                ejbModule.setPath(path);
                this.earInfo.addEJBModule(ejbModule);
            }
            NodeList javaList = moduleElement.getElementsByTagName("java");
            for (int j = 0; j < javaList.getLength(); ++j) {
                String path = javaList.item(j).getFirstChild().getNodeValue().trim();
                JavaModuleImpl javaModule = new JavaModuleImpl();
                javaModule.setPath(path);
                this.earInfo.addJavaModule(javaModule);
            }
            NodeList webList = moduleElement.getElementsByTagName("web");
            for (int j = 0; j < webList.getLength(); ++j) {
                Element webElement = (Element)webList.item(j);
                String path = webElement.getElementsByTagName("web-uri").item(0).getFirstChild().getNodeValue().trim();
                String contextRoot = webElement.getElementsByTagName("context-root").item(0).getFirstChild().getNodeValue().trim();
                if (contextRoot.startsWith("/") && !contextRoot.equals("/")) {
                    this.logger.debug((Object)"Context-Root ''{0}'' for module ''{1}'' contains invalid starting / in the name. Fixing it.", new Object[]{contextRoot, path});
                    int c = 0;
                    while (contextRoot.charAt(c) == '/') {
                        ++c;
                    }
                    contextRoot = contextRoot.substring(c);
                }
                WebModuleImpl webModule = new WebModuleImpl();
                webModule.setPath(path);
                webModule.setContextRoot(contextRoot);
                this.earInfo.addWebModule(webModule);
            }
        }
    }

    public List<EJBDeployable<?>> getEJBDeployables() {
        ArrayList ejbDeployables = new ArrayList();
        for (EJB21Deployable eJB21Deployable : this.ejb21Deployables) {
            ejbDeployables.add((EJBDeployable<?>)eJB21Deployable);
        }
        for (EJB3Deployable eJB3Deployable : this.ejb3Deployables) {
            ejbDeployables.add((EJBDeployable<?>)eJB3Deployable);
        }
        return ejbDeployables;
    }

    public List<EJB21Deployable> getEJB21Deployables() {
        return this.ejb21Deployables;
    }

    public List<EJB3Deployable> getEJB3Deployables() {
        return this.ejb3Deployables;
    }

    public List<WARDeployable> getWARDeployables() {
        return this.warDeployables;
    }

    public List<RARDeployable> getRARDeployables() {
        return this.rarDeployables;
    }

    public List<CARDeployable> getCARDeployables() {
        return this.carDeployables;
    }

    public List<LibDeployable> getLibDeployables() {
        return this.libDeployables;
    }

    public void addDeployable(IDeployable<?> deployable) {
        IDeployable<?> ezbDeployable = this.checkLibDeployable(deployable);
        this.allDeployables.add(ezbDeployable);
        if (ezbDeployable instanceof EJB21Deployable) {
            this.ejb21Deployables.add((EJB21Deployable)ezbDeployable);
        } else if (ezbDeployable instanceof EJB3Deployable) {
            this.ejb3Deployables.add((EJB3Deployable)ezbDeployable);
        } else if (ezbDeployable instanceof WARDeployable) {
            this.warDeployables.add((WARDeployable)ezbDeployable);
            this.setContextRoot((WARDeployable)ezbDeployable);
        } else if (ezbDeployable instanceof RARDeployable) {
            this.rarDeployables.add((RARDeployable)ezbDeployable);
        } else if (ezbDeployable instanceof CARDeployable) {
            this.carDeployables.add((CARDeployable)ezbDeployable);
        } else if (ezbDeployable instanceof LibDeployable) {
            this.libDeployables.add((LibDeployable)ezbDeployable);
        } else {
            throw new IllegalStateException("The EAR deployable archive doesn't support the include of archive with '" + ezbDeployable.getClass() + "' class object, deployable ='" + ezbDeployable + "'.");
        }
        try {
            URL urldeployable = deployable.getArchive().getURL();
            this.mapUrl.put(urldeployable, deployable);
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get URL of the deployable ", e);
        }
    }

    protected IDeployable<?> checkLibDeployable(IDeployable<?> deployable) {
        String relativeModuleName = this.getRelativeNameFromDeployable(deployable);
        if (relativeModuleName.startsWith(DEFAULT_LIBRARY_FOLDER)) {
            return new LibDeployableImpl(deployable.getArchive());
        }
        return deployable;
    }

    protected String getRelativeNameFromDeployable(IDeployable<?> deployable) {
        URL earURL = null;
        try {
            earURL = this.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL for the EAR file '" + this + "'.", e);
        }
        URL deployableURL = null;
        try {
            deployableURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get the URL for the deployable '" + deployable + "'.", e);
        }
        return deployableURL.toExternalForm().substring(earURL.toExternalForm().length());
    }

    protected void setContextRoot(WARDeployable warDeployable) {
        String relativeWarFileName = this.getRelativeNameFromDeployable((IDeployable<?>)warDeployable);
        boolean found = false;
        for (WebModule webModule : this.earInfo.getWebs()) {
            if (!relativeWarFileName.equals(webModule.getPath())) continue;
            String ctxRoot = webModule.getContextRoot();
            warDeployable.setContextRoot(ctxRoot);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Context root for War deployable ''{0}'' was found in the EAR {1} file, the value is ''{2}''", new Object[]{warDeployable, APPLICATION_XML_ENTRY, ctxRoot});
            }
            found = true;
            break;
        }
        if (!found) {
            String path;
            URL warURL = null;
            try {
                warURL = warDeployable.getArchive().getURL();
            }
            catch (ArchiveException e) {
                throw new IllegalStateException("Cannot get the URL for the deployable '" + warDeployable + "'.", e);
            }
            String cleanPath = path = warURL.getPath();
            if (cleanPath.endsWith("/")) {
                cleanPath = cleanPath.substring(path.length() - 1);
            }
            int sep = cleanPath.lastIndexOf("/");
            int dot = path.lastIndexOf(".");
            String ctxRoot = path.substring(sep + 1, dot);
            warDeployable.setContextRoot(ctxRoot);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"The entry for War deployable ''{0}'' was not found in the EAR application.xml file, using a default context-root value ''{1}''", new Object[]{warDeployable, ctxRoot});
            }
        }
    }

    public IEARInfo getEARInfo() {
        return this.earInfo;
    }

    public List<IDeployable> getAllDeployables() {
        return this.allDeployables;
    }

    public IDeployable getDeployable(URL url) {
        IDeployable deployable = null;
        if (this.mapUrl.containsKey(url)) {
            deployable = this.mapUrl.get(url);
        }
        return deployable;
    }
}

