/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployable;

import java.util.HashMap;
import java.util.Map;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployable<T extends IDeployable<T>>
implements IDeployable<T> {
    private IArchive archive = null;
    private T originalDeployable = null;
    private T unpackedDeployable = null;
    private Map<Class<? extends IDeployableInfo>, IDeployableInfo> extensions = null;

    public AbsDeployable(IArchive archive) {
        this.archive = archive;
        this.extensions = new HashMap<Class<? extends IDeployableInfo>, IDeployableInfo>();
    }

    public IArchive getArchive() {
        return this.archive;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[archive=");
        sb.append(this.archive.getName());
        sb.append("]");
        return sb.toString();
    }

    public T getOriginalDeployable() {
        return this.originalDeployable;
    }

    public void setOriginalDeployable(T originalDeployable) {
        this.originalDeployable = originalDeployable;
    }

    public T getUnpackedDeployable() {
        return this.unpackedDeployable;
    }

    public void setUnpackedDeployable(T unpackedDeployable) {
        this.unpackedDeployable = unpackedDeployable;
    }

    public void addExtension(IDeployableInfo extension) {
        this.extensions.put(extension.getClass(), extension);
    }

    public IDeployableInfo getExtension(Class<? extends IDeployableInfo> extensionClass) {
        return this.extensions.get(extensionClass);
    }

    public String getShortName() {
        String urlExternalForm;
        AbsDeployable deployable = this;
        while (deployable.getOriginalDeployable() != null) {
            deployable = deployable.getOriginalDeployable();
        }
        try {
            urlExternalForm = deployable.getArchive().getURL().toExternalForm();
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot get URL of the deployable '" + this + "'.", e);
        }
        if (urlExternalForm.charAt(urlExternalForm.length() - 1) == '/') {
            urlExternalForm = urlExternalForm.substring(0, urlExternalForm.length() - 1);
        }
        int slashPos = urlExternalForm.lastIndexOf(47);
        return urlExternalForm.substring(slashPos + 1, urlExternalForm.length());
    }

    public String getModuleName() {
        String moduleName = this.getShortName();
        int dotPos = moduleName.lastIndexOf(46);
        if (dotPos != -1) {
            moduleName = moduleName.substring(0, dotPos);
        }
        return moduleName;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IDeployable)) {
            return false;
        }
        IDeployable other = (IDeployable)object;
        try {
            return this.getArchive().getURL().equals(other.getArchive().getURL());
        }
        catch (ArchiveException e) {
            return super.equals(object);
        }
    }
}

