/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing;

import java.net.URL;
import java.util.List;
import javax.ejb.TransactionAttributeType;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.AbsDeploymentDescLoader;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.EJB3EntityResolver;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AbsBean;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.ContainerTransaction;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EJB3;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.InterceptorBinding;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptors;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MessageDriven;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MethodPermission;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.RemoveMethod;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Session;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.AbsEJBRef;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.AbsEnvironment;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.AbsResourceGroup;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.ActivationConfig;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.AroundInvoke;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.EJBLocalRef;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.EJBRef;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.EnvEntry;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.InjectionTarget;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.LifeCycleCallback;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.MessageDestinationRef;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.MethodDD;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.ResourceEnvRef;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.common.ResourceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public final class EJB3DeploymentDescLoader
extends AbsDeploymentDescLoader {
    private static Log logger = LogFactory.getLog(EJB3DeploymentDescLoader.class);
    private EJB3 ejb3 = new EJB3();

    private EJB3DeploymentDescLoader(URL url) {
        super(url);
    }

    public static EJB3 loadDeploymentDescriptor(URL url) throws ParsingException {
        logger.debug((Object)"Analyzing url {0}", new Object[]{url});
        EJB3DeploymentDescLoader ejbDeploymentDescLoader = new EJB3DeploymentDescLoader(url);
        ejbDeploymentDescLoader.parse();
        return ejbDeploymentDescLoader.getEJB3();
    }

    public void parse() throws ParsingException {
        NodeList assemblyDescriptorList;
        NodeList interceptorsList;
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)this.getURL(), (boolean)EJB3DeploymentDescLoader.isValidating(), (EntityResolver)((Object)new EJB3EntityResolver()));
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", e);
        }
        Element ejbJarRootElement = document.getDocumentElement();
        this.defineXMLNS(ejbJarRootElement);
        NodeList enterprisebeansList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "enterprise-beans");
        if (enterprisebeansList.getLength() == 1) {
            Element enterpriseBeansElement = (Element)enterprisebeansList.item(0);
            EnterpriseBeans enterpriseBeans = new EnterpriseBeans();
            this.ejb3.setEnterpriseBeans(enterpriseBeans);
            this.analyzeBeans(enterpriseBeansElement, enterpriseBeans);
        }
        if ((interceptorsList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "interceptors")).getLength() == 1) {
            Element interceptorsElement = (Element)interceptorsList.item(0);
            Interceptors interceptors = new Interceptors();
            this.ejb3.setInterceptors(interceptors);
            this.analyzeInterceptorsElement(interceptorsElement, interceptors);
        }
        if ((assemblyDescriptorList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "assembly-descriptor")).getLength() == 1) {
            Element assemblyDescriptorElement = (Element)assemblyDescriptorList.item(0);
            AssemblyDescriptor assemblyDescriptor = new AssemblyDescriptor();
            this.ejb3.setAssemblyDescriptor(assemblyDescriptor);
            this.analyzeAssemblyDescriptor(assemblyDescriptorElement, assemblyDescriptor);
        }
        if ("true".equals(ejbJarRootElement.getAttribute("metadata-complete"))) {
            this.ejb3.setMetadataComplete(true);
        } else {
            this.ejb3.setMetadataComplete(false);
        }
    }

    private void analyzeBeans(Element enterpriseBeansElement, EnterpriseBeans enterpriseBeans) {
        NodeList sessionBeansList = enterpriseBeansElement.getElementsByTagNameNS(this.getXMLNS(), "session");
        for (int i = 0; i < sessionBeansList.getLength(); ++i) {
            Element sessionElement = (Element)sessionBeansList.item(i);
            Session session = new Session();
            enterpriseBeans.addSession(session);
            this.analyzeSessionBean(sessionElement, session);
        }
        NodeList messageDrivenBeansList = enterpriseBeansElement.getElementsByTagNameNS(this.getXMLNS(), "message-driven");
        for (int i = 0; i < messageDrivenBeansList.getLength(); ++i) {
            Element mdbElement = (Element)messageDrivenBeansList.item(i);
            MessageDriven messageDriven = new MessageDriven();
            enterpriseBeans.addMessageDriven(messageDriven);
            this.analyzeMessageDrivenBean(mdbElement, messageDriven);
        }
    }

    private void analyzeBean(Element beanElement, AbsBean bean) {
        String mappedName;
        String ejbName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"ejb-name");
        bean.setEjbName(ejbName);
        String ejbClass = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"ejb-class");
        bean.setEjbClass(ejbClass);
        String runAsRole = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"role-name");
        if (runAsRole != null) {
            bean.setRunAsRole(runAsRole);
        }
        if ((mappedName = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"mapped-name")) != null) {
            bean.setMappedName(mappedName);
        }
        String transactionType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"transaction-type");
        bean.setTransactionType(transactionType);
        this.analyzeEnvironment(beanElement, bean);
    }

    private void analyzeMessageDrivenBean(Element beanElement, MessageDriven bean) {
        this.analyzeBean(beanElement, bean);
        String messageDestinationType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"message-destination-type");
        bean.setMessageDestinationType(messageDestinationType);
        String messageDestinationLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"message-destination-link");
        bean.setMessageDestinationLink(messageDestinationLink);
        String messagingType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"messaging-type");
        bean.setMessagingType(messagingType);
        NodeList activationConfigList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "activation-config");
        for (int i = 0; i < activationConfigList.getLength(); ++i) {
            Element activationConfigElement = (Element)activationConfigList.item(i);
            NodeList activationConfigPropertyList = activationConfigElement.getElementsByTagNameNS(this.getXMLNS(), "activation-config-property");
            for (int j = 0; j < activationConfigPropertyList.getLength(); ++j) {
                Element activationConfigPropertyElement = (Element)activationConfigPropertyList.item(j);
                ActivationConfig activationConfig = new ActivationConfig();
                bean.addActivationConfig(activationConfig);
                String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)activationConfigPropertyElement, (String)"activation-config-property-name");
                String value = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)activationConfigPropertyElement, (String)"activation-config-property-value");
                activationConfig.setName(name);
                activationConfig.setValue(value);
            }
        }
    }

    private void analyzeSessionBean(Element beanElement, Session bean) {
        this.analyzeBean(beanElement, bean);
        List businessRemoteList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"business-remote");
        for (String businessRemote : businessRemoteList) {
            bean.addBusinessRemote(businessRemote);
        }
        List businessLocalList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"business-local");
        for (String businessLocal : businessLocalList) {
            bean.addBusinessLocal(businessLocal);
        }
        NodeList removeMethodList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "remove-method");
        for (int i = 0; i < removeMethodList.getLength(); ++i) {
            Element removeMethodElement = (Element)removeMethodList.item(i);
            RemoveMethod removeMethod = new RemoveMethod();
            bean.addRemoveMethod(removeMethod);
            NodeList beanMethodList = removeMethodElement.getElementsByTagNameNS(this.getXMLNS(), "bean-method");
            removeMethod.setMethod(this.getMethodFromElement((Element)beanMethodList.item(0)));
            String retainIfExceptionStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)removeMethodElement, (String)"retain-if-exception");
            if (retainIfExceptionStr == null) continue;
            boolean retainIfException = false;
            retainIfException = Boolean.parseBoolean(retainIfExceptionStr);
            removeMethod.setRetainIfException(retainIfException);
        }
        String remoteHome = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"home");
        bean.setRemoteHome(remoteHome);
        String localHome = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"local-home");
        bean.setLocalHome(localHome);
        String sessionType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"session-type");
        bean.setSessionType(sessionType);
    }

    private MethodDD getMethodFromElement(Element methodElement) {
        MethodDD method = new MethodDD();
        String methodName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)methodElement, (String)"method-name");
        method.setName(methodName);
        String ejbName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)methodElement, (String)"ejb-name");
        method.setEjbName(ejbName);
        NodeList methodParamsList = methodElement.getElementsByTagNameNS(this.getXMLNS(), "method-params");
        if (methodParamsList != null && methodParamsList.getLength() == 1) {
            Element methodParamsElement = (Element)methodParamsList.item(0);
            List paramList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)methodParamsElement, (String)"method-param");
            for (String param : paramList) {
                method.addParam(param);
            }
        }
        return method;
    }

    private void analyzeEnvironment(Element envElement, AbsEnvironment bean) {
        this.analyzeLifeCycle(envElement, bean, "post-construct");
        this.analyzeLifeCycle(envElement, bean, "pre-destroy");
        this.analyzeLifeCycle(envElement, bean, "pre-passivate");
        this.analyzeLifeCycle(envElement, bean, "post-activate");
        this.analyzeAroundInvoke(envElement, bean);
        this.analyzeEnvEnvtry(envElement, bean);
        this.analyzeEJBRef(envElement, bean);
        this.analyzeEJBLocalRef(envElement, bean);
        this.analyzeResourceRef(envElement, bean);
        this.analyzeResourceEnvRef(envElement, bean);
        this.analyzeMessageDestinationRef(envElement, bean);
    }

    private void analyzeCommonEJBRef(Element refElement, AbsEJBRef ref) {
        String ejbRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-name");
        ref.setEjbRefName(ejbRefName);
        String ejbRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-ref-type");
        ref.setEjbRefType(ejbRefType);
        String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"mapped-name");
        ref.setMappedName(mappedName);
        String ejbLink = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)refElement, (String)"ejb-link");
        ref.setEjbLink(ejbLink);
        this.analyzeInjectionTarget(refElement, ref);
    }

    private void analyzeInjectionTarget(Element refElement, AbsResourceGroup resourceGroup) {
        NodeList injectionTargetList = refElement.getElementsByTagNameNS(this.getXMLNS(), "injection-target");
        for (int j = 0; j < injectionTargetList.getLength(); ++j) {
            Element injectionTargetElement = (Element)injectionTargetList.item(j);
            InjectionTarget injectionTarget = new InjectionTarget();
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-class");
            injectionTarget.setClassname(className);
            String targetName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)injectionTargetElement, (String)"injection-target-name");
            injectionTarget.setTargetName(targetName);
            resourceGroup.addInjectionTarget(injectionTarget);
        }
    }

    private void analyzeEJBRef(Element envElement, AbsEnvironment env) {
        NodeList ejbRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-ref");
        for (int i = 0; i < ejbRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbRefList.item(i);
            EJBRef ejbRef = new EJBRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbRef);
            String remote = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"remote");
            ejbRef.setRemote(remote);
            String home = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"home");
            ejbRef.setHome(home);
            env.addEJBRef(ejbRef);
        }
    }

    private void analyzeResourceRef(Element envElement, AbsEnvironment env) {
        NodeList resourceRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-ref");
        for (int i = 0; i < resourceRefList.getLength(); ++i) {
            Element resourceRefElement = (Element)resourceRefList.item(i);
            ResourceRef resourceRef = new ResourceRef();
            String resRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-ref-name");
            resourceRef.setResRefName(resRefName);
            String resRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"res-type");
            resourceRef.setResRefType(resRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceRefElement, (String)"mapped-name");
            resourceRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceRefElement, resourceRef);
            env.addResourceRef(resourceRef);
        }
    }

    private void analyzeMessageDestinationRef(Element envElement, AbsEnvironment env) {
        NodeList messageDestinationRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "message-destination-ref");
        for (int i = 0; i < messageDestinationRefList.getLength(); ++i) {
            Element messageDestinationRefElement = (Element)messageDestinationRefList.item(i);
            MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
            String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-ref-name");
            messageDestinationRef.setName(name);
            String type = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-type");
            messageDestinationRef.setType(type);
            String usage = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-usage");
            messageDestinationRef.setUsage(usage);
            String link = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"message-destination-link");
            messageDestinationRef.setLink(link);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationRefElement, (String)"mapped-name");
            messageDestinationRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(messageDestinationRefElement, messageDestinationRef);
            env.addMessageDestinationRef(messageDestinationRef);
        }
    }

    private void analyzeResourceEnvRef(Element envElement, AbsEnvironment env) {
        NodeList resourceEnvRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "resource-env-ref");
        for (int i = 0; i < resourceEnvRefList.getLength(); ++i) {
            Element resourceEnvRefElement = (Element)resourceEnvRefList.item(i);
            ResourceEnvRef resourceEnvRef = new ResourceEnvRef();
            String resourceEnvRefName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-name");
            resourceEnvRef.setResourceEnvRefName(resourceEnvRefName);
            String resourceEnvRefType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"resource-env-ref-type");
            resourceEnvRef.setResourceEnvRefType(resourceEnvRefType);
            String mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)resourceEnvRefElement, (String)"mapped-name");
            resourceEnvRef.setMappedName(mappedName);
            this.analyzeInjectionTarget(resourceEnvRefElement, resourceEnvRef);
            env.addResourceEnvRef(resourceEnvRef);
        }
    }

    private void analyzeEJBLocalRef(Element envElement, AbsEnvironment env) {
        NodeList ejbLocalRefList = envElement.getElementsByTagNameNS(this.getXMLNS(), "ejb-local-ref");
        for (int i = 0; i < ejbLocalRefList.getLength(); ++i) {
            Element ejbRefElement = (Element)ejbLocalRefList.item(i);
            EJBLocalRef ejbLocalRef = new EJBLocalRef();
            this.analyzeCommonEJBRef(ejbRefElement, ejbLocalRef);
            String local = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local");
            ejbLocalRef.setLocal(local);
            String localHome = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)ejbRefElement, (String)"local-home");
            ejbLocalRef.setLocalHome(localHome);
            env.addEJBLocalRef(ejbLocalRef);
        }
    }

    private void analyzeAroundInvoke(Element envElement, AbsEnvironment env) {
        NodeList aroundInvokeList = envElement.getElementsByTagNameNS(this.getXMLNS(), "around-invoke");
        for (int i = 0; i < aroundInvokeList.getLength(); ++i) {
            Element aroundInvokeElement = (Element)aroundInvokeList.item(i);
            AroundInvoke aroundInvoke = new AroundInvoke();
            env.addAroundInvoke(aroundInvoke);
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)aroundInvokeElement, (String)"class");
            aroundInvoke.setClassName(className);
            String method = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)aroundInvokeElement, (String)"method-name");
            aroundInvoke.setMethodName(method);
        }
    }

    private void analyzeLifeCycle(Element envElement, AbsEnvironment env, String lifecycleName) {
        NodeList lifecycleList = envElement.getElementsByTagNameNS(this.getXMLNS(), lifecycleName);
        for (int i = 0; i < lifecycleList.getLength(); ++i) {
            Element lifeCycleElement = (Element)lifecycleList.item(i);
            LifeCycleCallback lifecycleCallback = new LifeCycleCallback();
            if ("post-construct".equals(lifecycleName)) {
                env.addPostConstructCallback(lifecycleCallback);
            } else if ("pre-destroy".equals(lifecycleName)) {
                env.addPreDestroyCallback(lifecycleCallback);
            } else if ("pre-passivate".equals(lifecycleName)) {
                env.addPrePassivateCallback(lifecycleCallback);
            } else if ("post-activate".equals(lifecycleName)) {
                env.addPostActivateCallback(lifecycleCallback);
            } else {
                throw new IllegalArgumentException("Unknown lifecycle named '" + lifecycleName + "'.");
            }
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-class");
            lifecycleCallback.setLifecycleCallbackClass(className);
            String method = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)lifeCycleElement, (String)"lifecycle-callback-method");
            lifecycleCallback.setMethodName(method);
        }
    }

    private void analyzeEnvEnvtry(Element envElement, AbsEnvironment bean) {
        NodeList envEntryList = envElement.getElementsByTagNameNS(this.getXMLNS(), "env-entry");
        for (int i = 0; i < envEntryList.getLength(); ++i) {
            Element envEntryElement = (Element)envEntryList.item(i);
            EnvEntry envEntry = new EnvEntry();
            bean.addEnvEntry(envEntry);
            String envEntryName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-name");
            envEntry.setEnvEntryName(envEntryName);
            String envEntryType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-type");
            envEntry.setEnvEntryType(envEntryType);
            String envEntryValue = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)envEntryElement, (String)"env-entry-value");
            envEntry.setEnvEntryValue(envEntryValue);
        }
    }

    private void analyzeInterceptorsElement(Element interceptorsElement, Interceptors interceptors) {
        NodeList interceptorList = interceptorsElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            Interceptor interceptor = new Interceptor();
            interceptors.addInterceptor(interceptor);
            String interceptorClass = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorElement, (String)"interceptor-class");
            interceptor.setInterceptorClass(interceptorClass);
            this.analyzeEnvironment(interceptorElement, interceptor);
        }
    }

    private void analyzeAssemblyDescriptor(Element assemblyDescriptorElement, AssemblyDescriptor assemblyDescriptor) {
        this.analyzeApplicationException(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeInterceptorBinding(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeContainerTransaction(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeSecurity(assemblyDescriptorElement, assemblyDescriptor);
    }

    private void analyzeInterceptorBinding(Element assemblyDescriptorElement, AssemblyDescriptor assemblyDescriptor) {
        NodeList interceptorBindingList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor-binding");
        for (int i = 0; i < interceptorBindingList.getLength(); ++i) {
            String excludeDefaultInterceptorsStr;
            String excludeClassInterceptorsStr;
            NodeList methodList;
            Element interceptorBindingElement = (Element)interceptorBindingList.item(i);
            InterceptorBinding interceptorBinding = new InterceptorBinding();
            assemblyDescriptor.addInterceptorBinding(interceptorBinding);
            String ejbName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"ejb-name");
            interceptorBinding.setEjbName(ejbName);
            NodeList interceptorOrderList = interceptorBindingElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor-order");
            if (interceptorOrderList != null && interceptorOrderList.getLength() == 1) {
                Element interceptorOrderElement = (Element)interceptorOrderList.item(0);
                List interceptorOrderClassList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)interceptorOrderElement, (String)"interceptor-class");
                for (String interceptorClass : interceptorOrderClassList) {
                    interceptorBinding.addOrderedInterceptorClass(interceptorClass);
                }
            } else {
                List interceptorClassList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"interceptor-class");
                for (String interceptorClass : interceptorClassList) {
                    interceptorBinding.addInterceptorClass(interceptorClass);
                }
            }
            if ((methodList = interceptorBindingElement.getElementsByTagNameNS(this.getXMLNS(), "method")).getLength() > 0) {
                interceptorBinding.setMethod(this.getMethodFromElement((Element)methodList.item(0)));
            }
            if ((excludeClassInterceptorsStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"exclude-class-interceptors")) != null) {
                boolean excludeClassInterceptors = false;
                excludeClassInterceptors = Boolean.parseBoolean(excludeClassInterceptorsStr);
                interceptorBinding.setExcludeClassInterceptors(excludeClassInterceptors);
            }
            if ((excludeDefaultInterceptorsStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"exclude-default-interceptors")) == null) continue;
            boolean excludeDefaultInterceptors = false;
            excludeDefaultInterceptors = Boolean.parseBoolean(excludeDefaultInterceptorsStr);
            interceptorBinding.setExcludeDefaultInterceptors(excludeDefaultInterceptors);
        }
    }

    private void analyzeApplicationException(Element assemblyDescriptorElement, AssemblyDescriptor assemblyDescriptor) {
        NodeList applicationExceptionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "application-exception");
        for (int i = 0; i < applicationExceptionList.getLength(); ++i) {
            Element applicationExceptionElement = (Element)applicationExceptionList.item(i);
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)applicationExceptionElement, (String)"exception-class");
            String rollbackStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)applicationExceptionElement, (String)"rollback");
            boolean rollback = false;
            if (rollbackStr != null) {
                rollback = Boolean.parseBoolean(rollbackStr);
            }
            JApplicationException applicationException = new JApplicationException(className, rollback);
            assemblyDescriptor.addApplicationException(applicationException);
        }
    }

    private void analyzeContainerTransaction(Element assemblyDescriptorElement, AssemblyDescriptor assemblyDescriptor) {
        NodeList containerTransactionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "container-transaction");
        for (int i = 0; i < containerTransactionList.getLength(); ++i) {
            Element containerTransactionElement = (Element)containerTransactionList.item(i);
            ContainerTransaction containerTransaction = new ContainerTransaction();
            assemblyDescriptor.addContainerTransaction(containerTransaction);
            NodeList methodList = containerTransactionElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                containerTransaction.addMethod(this.getMethodFromElement(methodElement));
            }
            String transactionAttribute = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)containerTransactionElement, (String)"trans-attribute");
            if (transactionAttribute == null) continue;
            if ("NotSupported".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.NOT_SUPPORTED);
                continue;
            }
            if ("Supports".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.SUPPORTS);
                continue;
            }
            if ("Required".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.REQUIRED);
                continue;
            }
            if ("RequiresNew".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.REQUIRES_NEW);
                continue;
            }
            if ("Mandatory".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.MANDATORY);
                continue;
            }
            if ("Never".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.NEVER);
                continue;
            }
            throw new IllegalStateException("Invalid transaction attribute '" + transactionAttribute + "'");
        }
    }

    private void analyzeSecurity(Element assemblyDescriptorElement, AssemblyDescriptor assemblyDescriptor) {
        NodeList securityRoleList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "security-role");
        for (int i = 0; i < securityRoleList.getLength(); ++i) {
            Element securityRoleElement = (Element)securityRoleList.item(i);
            String securityRole = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)securityRoleElement, (String)"role-name");
            if (securityRole == null) continue;
            assemblyDescriptor.addSecurityRole(securityRole);
        }
        NodeList methodPermissionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "method-permission");
        for (int i = 0; i < methodPermissionList.getLength(); ++i) {
            Element methodPermissionElement = (Element)methodPermissionList.item(i);
            MethodPermission methodPermission = new MethodPermission();
            assemblyDescriptor.addMethodPermission(methodPermission);
            List roles = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)methodPermissionElement, (String)"role-name");
            for (String roleName : roles) {
                methodPermission.addRoleName(roleName);
            }
            NodeList uncheckedList = methodPermissionElement.getElementsByTagNameNS(this.getXMLNS(), "unchecked");
            if (uncheckedList.getLength() > 0) {
                methodPermission.setUnchecked(true);
            }
            NodeList methodList = methodPermissionElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                methodPermission.addMethod(this.getMethodFromElement(methodElement));
            }
        }
        NodeList excludeList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "exclude-list");
        for (int i = 0; i < excludeList.getLength(); ++i) {
            Element excludeListElement = (Element)excludeList.item(i);
            NodeList methodList = excludeListElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                assemblyDescriptor.addExcludeList(this.getMethodFromElement(methodElement));
            }
        }
    }

    public EJB3 getEJB3() {
        return this.ejb3;
    }
}

