/**
 * OW2 Util
 * Copyright (C) 2008 
 * Contact: easybeans@objectweb.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: DeploymentPlanDeployable.java 
* --------------------------------------------------------------------------
*/

package org.ow2.util.plan.deploy.deployable.api;

import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlan;

/**
 * interface for deployment plan deployables.
 * @author mleduque
 */
public interface DeploymentPlanDeployable extends
    FileDeployable<DeploymentPlanDeployable, DeploymentPlan> {

    /**
     * Returns the bindings data attached to the deployable.
     * @return the bindings data.
     */
    public DeploymentPlan getAttachedData();

    /**
     * Sets the bindings data attached to the deployable.
     * @param attachedData the bindings data.
     */
    public void setAttachedData(final DeploymentPlan attachedData);

}
