/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@objectweb.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: FileDeployable.java 
* --------------------------------------------------------------------------
*/

package org.ow2.util.plan.deploy.deployable.api;

import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/**
 * Interface for deployables built upon a single file that is not
 * a JAR file.
 * @author mleduque
 * @param <T> the type of the deployable.
 * @param <U> the type of the attached data.
 */
public interface FileDeployable<T extends IDeployable<T>, U> extends IDeployable<T> {

    /**
     * Gets the data attached to this deployable.
     * @return the attached data
     */
    public U getAttachedData();

    /**
     * Sets the data attached to this deployable.
     * @param attachedData the new attached data.
     */
    public void setAttachedData(final U attachedData);
}
