/**
 * OW2 Util
 * Copyright (C) 2008 
 * Contact: easybeans@objectweb.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: IFileDeployableFactory.java
* --------------------------------------------------------------------------
*/

package org.ow2.util.plan.deploy.deployable.api.factory;

import org.ow2.util.archive.api.IFileArchive;
import org.ow2.util.plan.deploy.deployable.api.FileDeployable;

/**
 * Base interface for FileDeployable factories.
 * @author mleduque
 */
public interface IFileDeployableFactory {
    /**
     * Creates and returns a FileDeployable from the given FileArchive.
     * @param fileArchive the file archive.
     * @return a file deployable.
     * @throws FileDeployableException when the file deployable
     *  could not be created.
     */
    public FileDeployable<?, ?> getFileDeployable(final IFileArchive fileArchive)
                                            throws FileDeployableException;

}
