/**
 * OW2 Util
 * Copyright (C) 2008 
 * Contact: easybeans@objectweb.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: IFileDeployableFactoryManager.java
* --------------------------------------------------------------------------
*/

package org.ow2.util.plan.deploy.deployable.api.factory;

/**
 * Interface for FileDeployable factories that use factories to produce
 * file deployables.
 * @author mleduque
 */
public interface IFileDeployableFactoryManager extends IFileDeployableFactory {
    /**
     * Adds a factory to the managed ones.
     * @param factory the added factory.
     */
    public void addFileDeployableFactory(IFileDeployableFactory factory);
    /**
     * Removes a factory from the managed ones.
     * @param factory the removed factory.
     */
    public void removeFileDeployableFactory(IFileDeployableFactory factory);
}
