/**
 * OW2 Util
 * Copyright (C) 2008 
 * Contact: easybeans@objectweb.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: XmlFileDeployableFactory.java 
* --------------------------------------------------------------------------
*/

package org.ow2.util.plan.deploy.deployable.api.factory;


import org.ow2.util.plan.deploy.deployable.api.FileDeployable;

/**
 * Interface for the deployable factories that create factories from
 * XML files.
 * @author mleduque
 */
public interface XmlFileDeployableFactory extends IFileDeployableFactory {
    /**
     * Add a namespace-FileDeployable class mapping in the factory.
     * @param clazz the class.
     * @param nameSpace the namespace.
     */
    public void registerFileDeployable(final Class<? extends FileDeployable<?, ?>> clazz,
            final String nameSpace);

    /**
     *  Removes a namespace-FileDeployable class mapping from the factory.
     * @param nameSpace the namespace.
     */
    public void unregisterFileDeployable(final String nameSpace);

}
