/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IPool.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api;


/**
 * A pool is a class which keep some pool item.
 * @author Gael Lalire
 * @param <T> pool item type
 */
public interface IPool<T> {

    /**
     * Never returns a {@link TimeoutPoolException}.
     */
    int INFINITE_TIMEOUT = -1;

    /**
     * This method block is there is no available pool item
     * in the pool.
     * @param timeout if the get wait more than timeout then the method
     * throw a {@link TimeoutPoolException}.
     * @return a pool item
     * @throws PoolException if error occurs
     */
    T get(long timeout) throws PoolException;

    /**
     * This method must be called when you finished to use
     * the pool item.
     * @param poolItem a pool item
     * @throws NotABusyPoolItemException if error occurs
     */
    void put(final T poolItem) throws NotABusyPoolItemException;

    /**
     * This method can be called when you finished to use
     * the pool item instead of put method.
     *
     * If you call this method the pool item will be replace
     * with a new.
     *
     * @param poolItem a pool item
     * @throws NotABusyPoolItemException if error occurs
     */
    void remove(final T poolItem) throws NotABusyPoolItemException;

    /**
     * All waiters will be interrupted and throw an {@link WaiterInterruptedException}.
     */
    void interruptAllWaiters();

}
