/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IAccessManager.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api.basic.accessmanager;

import java.util.List;

/**
 *
 * @author Gael Lalire
 * @param <E>
 */
public interface IAccessManager<E> {

    /**
     * If you return this value it mean you do not want to choose an
     * item.
     */
    int DELAY_GET = -1;

    /**
     * @param poolItemList the list of pool item
     * @return a value between 0 and poolItemList.size()-1
     */
    int choosePoolItemToRelease(List<? extends E> poolItemList);

    /**
     * @param poolItemList the list of pool item
     * @return a value between 0 and poolItemList.size()-1 or
     * DELAY_GET.
     */
    int choosePoolItemToGet(List<? extends E> poolItemList);

    /**
     * @param poolItemList the list of pool item
     * @param poolItem poolItem to put in list
     * @return a value between 0 and poolItemList.size()
     */
    int putPoolItem(List<? extends E> poolItemList, E poolItem);

    /**
     * @param poolItemList the list of pool item
     * @param poolItem poolItem to put in list
     * @return a value between 0 and poolItemList.size()
     */
    int createPoolItem(List<? extends E> poolItemList, E poolItem);

    /**
     * @param poolItem poolItem
     */
    void removePoolItem(E poolItem);

}
