/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IBasicCluePool.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api.basic.clue;

import org.ow2.util.pool.impl.enhanced.api.IllegalTimeoutException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.WaiterInterruptedException;
import org.ow2.util.pool.impl.enhanced.api.basic.IBasicPool;
import org.ow2.util.pool.impl.enhanced.api.resizer.clue.IResizableCluePool;

/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 */
public interface IBasicCluePool<E, C> extends IBasicPool<E>, IResizableCluePool<E, C> {

    E get(C clue) throws WaiterInterruptedException;

    E get(C clue, long timeout) throws TimeoutPoolException, IllegalTimeoutException, WaiterInterruptedException;

}
