/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IClueShareManager.java 4601 2009-02-16 09:35:38Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api.keepbusy.clue;

import java.util.List;

/**
 *
 * @author Gael Lalire
 */
public interface IClueShareManager<E, C> {

    /**
     * @param clue a clue
     * @param poolItemList the list of pool item
     * @return a value between 0 and poolItemList.size()-1 or
     * NO_POOL_ITEM_SHAREABLE if you do not want to share
     */
    int choosePoolItemToShare(C clue, List<E> poolItemList);

}
