/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IPoolListener.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api.listener;

import org.ow2.util.pool.impl.enhanced.api.PoolException;

/**
 *
 * @author Gael Lalire
 * @param <T>
 */
public interface IPoolListener<T> {

    void getMethodCalled(long timeout);

    void getMethodReturned(T result, long timeout);

    void getMethodFailed(PoolException poolException, long timeout);

    void putMethodCalled(T poolItem);

    void putMethodReturned(T poolItem);

    void putMethodFailed(PoolException poolException, T poolItem);

    void removeMethodCalled(T poolItem);

    void removeMethodReturned(T poolItem);

    void removeMethodFailed(PoolException poolException, T poolItem);

    void interruptAllWaitersMethodCalled();

    void interruptAllWaitersMethodReturned();

}
