/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IPoolItemRecorder.java 4809 2009-03-15 10:13:49Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api.recorder;


/**
 * Methods of this interface have to be thread safe.
 * @param <E> pool item type
 * @param <I> identifier type
 * @author Gael Lalire
 */
public interface IPoolItemRecorder<E, I> {

    /**
     * This method must not modify poolItem while recording, so if the record is
     * aborted the poolItem can be returned without an useless fetch.
     *
     * The latestIdentifier will not be use in future so if you are not reusing it (return
     * the same identifier) you should remove data keeped by latestIdentifier.
     *
     * @param poolItem a pool item to record
     * @param latestIdentifier the latest identifier fetch (below) method returns
     * @return an identifier which will be used to fetch this item
     */
    I record(E poolItem, I latestIdentifier);

    /**
     * The identifier has to still be valid after the fetch, so if fetch is aborted we
     * can call again the method in future.
     *
     * @param identifier this information contains information to fetch the item
     * @return a fetched item
     */
    E fetch(I identifier);

    /**
     * The identifier will not be use in future because the item has been removed from pool or
     * the pool is finalized for example.
     * @param identifier an identifier
     */
    void remove(I identifier);

}
